/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.collections;

import de.flapdoodle.collections.ImmutableTypedMap;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="ImmutableTypedMap", generator="Immutables")
public final class GeneratedImmutableTypedMap<K>
extends ImmutableTypedMap<K> {
    private final Map<Pair<K, ? extends TypeInfo<?>>, Object> map;
    private volatile transient long lazyInitBitmap;
    private static final long KEY_SET_LAZY_INIT_BIT = 1L;
    private transient Set<Pair<K, ? extends TypeInfo<?>>> keySet;

    private GeneratedImmutableTypedMap(Map<Pair<K, ? extends TypeInfo<?>>, Object> map) {
        this.map = map;
    }

    @Override
    protected Map<Pair<K, ? extends TypeInfo<?>>, Object> map() {
        return this.map;
    }

    public final GeneratedImmutableTypedMap<K> withMap(Map<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entries) {
        if (this.map == entries) {
            return this;
        }
        Map<Pair<K, ? extends TypeInfo<?>>, Object> newValue = GeneratedImmutableTypedMap.createUnmodifiableMap(true, false, entries);
        return new GeneratedImmutableTypedMap<K>(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GeneratedImmutableTypedMap && this.equalTo(0, (GeneratedImmutableTypedMap)another);
    }

    private boolean equalTo(int synthetic, GeneratedImmutableTypedMap<?> another) {
        return this.map.equals(another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.map.hashCode();
        return h;
    }

    public String toString() {
        return "ImmutableTypedMap{map=" + this.map + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Pair<K, ? extends TypeInfo<?>>> keySet() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            GeneratedImmutableTypedMap generatedImmutableTypedMap = this;
            synchronized (generatedImmutableTypedMap) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.keySet = Objects.requireNonNull(super.keySet(), "keySet");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.keySet;
    }

    public static <K> GeneratedImmutableTypedMap<K> copyOf(ImmutableTypedMap<K> instance) {
        if (instance instanceof GeneratedImmutableTypedMap) {
            return (GeneratedImmutableTypedMap)instance;
        }
        return GeneratedImmutableTypedMap.builder().from(instance).build();
    }

    public static <K> Builder<K> builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ImmutableTypedMap", generator="Immutables")
    public static final class Builder<K> {
        private Map<Pair<K, ? extends TypeInfo<?>>, Object> map = new LinkedHashMap();

        private Builder() {
        }

        public final Builder<K> from(ImmutableTypedMap<K> instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllMap(instance.map());
            return this;
        }

        public final Builder<K> putMap(Pair<K, ? extends TypeInfo<?>> key, Object value) {
            this.map.put(Objects.requireNonNull(key, "map key"), Objects.requireNonNull(value, value == null ? "map value for key: " + key : null));
            return this;
        }

        public final Builder<K> putMap(Map.Entry<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entry) {
            Pair<K, ? extends TypeInfo<?>> k = entry.getKey();
            Object v = entry.getValue();
            this.map.put(Objects.requireNonNull(k, "map key"), Objects.requireNonNull(v, v == null ? "map value for key: " + k : null));
            return this;
        }

        public final Builder<K> map(Map<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entries) {
            this.map.clear();
            return this.putAllMap(entries);
        }

        public final Builder<K> putAllMap(Map<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entries) {
            for (Map.Entry<Pair<K, TypeInfo<?>>, Object> e : entries.entrySet()) {
                Pair<K, ? extends TypeInfo<?>> k = e.getKey();
                Object v = e.getValue();
                this.map.put(Objects.requireNonNull(k, "map key"), Objects.requireNonNull(v, v == null ? "map value for key: " + k : null));
            }
            return this;
        }

        public GeneratedImmutableTypedMap<K> build() {
            return new GeneratedImmutableTypedMap(GeneratedImmutableTypedMap.createUnmodifiableMap(false, false, this.map));
        }
    }
}

