/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import java.util.function.Function;

public interface ThrowingRunnable<E extends Exception> {
    public void run() throws E;

    default public <N extends Exception> ThrowingRunnable<N> mapException(Function<Exception, N> exceptionMapper) {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    default public Runnable mapToUncheckedException(Function<Exception, RuntimeException> exceptionMapper) {
        return this.mapException(exceptionMapper)::run;
    }

    default public ThrowingRunnable<E> andFinally(Runnable runnable) {
        return () -> {
            try {
                this.run();
            }
            finally {
                runnable.run();
            }
        };
    }
}

