/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.reverse.ImmutableState;
import de.flapdoodle.reverse.TearDown;
import java.util.Optional;
import java.util.function.BiFunction;
import org.immutables.builder.Builder;
import org.immutables.value.Value;

@Value.Immutable
public interface State<T> {
    @Builder.Parameter
    public T value();

    public Optional<TearDown<T>> onTearDown();

    public static <T> ImmutableState.Builder<T> builder(T current) {
        return ImmutableState.builder(current);
    }

    @SafeVarargs
    public static <T> State<T> of(T current, TearDown<T> ... tearDowns) {
        return State.builder(current).onTearDown(TearDown.aggregate(tearDowns)).build();
    }

    @SafeVarargs
    public static <A, B, D> State<D> merge(State<A> a, State<B> b, BiFunction<A, B, D> merge, TearDown<D> ... tearDowns) {
        return State.builder(merge.apply(a.value(), b.value())).onTearDown(TearDown.aggregate(tearDowns)).build();
    }
}

