package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link State}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableState.builder()}.
 */
@Generated(from = "State", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableState<T> implements State<T> {
  private final T value;
  private final TearDown<T> onTearDown;

  private ImmutableState(T value, TearDown<T> onTearDown) {
    this.value = value;
    this.onTearDown = onTearDown;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T value() {
    return value;
  }

  /**
   * @return The value of the {@code onTearDown} attribute
   */
  @Override
  public Optional<TearDown<T>> onTearDown() {
    return Optional.ofNullable(onTearDown);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link State#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableState<T> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableState<>(newValue, this.onTearDown);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link State#onTearDown() onTearDown} attribute.
   * @param value The value for onTearDown
   * @return A modified copy of {@code this} object
   */
  public final ImmutableState<T> withOnTearDown(TearDown<T> value) {
    TearDown<T> newValue = Objects.requireNonNull(value, "onTearDown");
    if (this.onTearDown == newValue) return this;
    return new ImmutableState<>(this.value, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link State#onTearDown() onTearDown} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for onTearDown
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableState<T> withOnTearDown(Optional<? extends TearDown<T>> optional) {
    TearDown<T> value = optional.orElse(null);
    if (this.onTearDown == value) return this;
    return new ImmutableState<>(this.value, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableState<?>
        && equalTo(0, (ImmutableState<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableState<?> another) {
    return value.equals(another.value)
        && Objects.equals(onTearDown, another.onTearDown);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code onTearDown}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + Objects.hashCode(onTearDown);
    return h;
  }

  /**
   * Prints the immutable value {@code State} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("State{");
    builder.append("value=").append(value);
    if (onTearDown != null) {
      builder.append(", ");
      builder.append("onTearDown=").append(onTearDown);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link State} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable State instance
   */
  public static <T> ImmutableState<T> copyOf(State<T> instance) {
    if (instance instanceof ImmutableState<?>) {
      return (ImmutableState<T>) instance;
    }
    return ImmutableState.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableState ImmutableState}.
   * <pre>
   * ImmutableState.&amp;lt;T&amp;gt;builder()
   *    .value(T) // required {@link State#value() value}
   *    .onTearDown(de.flapdoodle.reverse.TearDown&amp;lt;T&amp;gt;) // optional {@link State#onTearDown() onTearDown}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param value {@code value} parameter
   * @return A new ImmutableState builder
   */
  public static <T> ImmutableState.Builder<T> builder(T value) {
    return new ImmutableState.Builder<>(value);
  }

  static <T> ImmutableState.Builder<T> builder() {
    return new ImmutableState.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableState ImmutableState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "State", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private T value;
    private TearDown<T> onTearDown;

    private Builder(T value) {
      value(value);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code State} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(State<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.value(instance.value());
      Optional<TearDown<T>> onTearDownOptional = instance.onTearDown();
      if (onTearDownOptional.isPresent()) {
        onTearDown(onTearDownOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link State#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<T> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the optional value {@link State#onTearDown() onTearDown} to onTearDown.
     * @param onTearDown The value for onTearDown
     * @return {@code this} builder for chained invocation
     */
    public final Builder<T> onTearDown(TearDown<T> onTearDown) {
      this.onTearDown = Objects.requireNonNull(onTearDown, "onTearDown");
      return this;
    }

    /**
     * Initializes the optional value {@link State#onTearDown() onTearDown} to onTearDown.
     * @param onTearDown The value for onTearDown
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> onTearDown(Optional<? extends TearDown<T>> onTearDown) {
      this.onTearDown = onTearDown.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableState ImmutableState}.
     * @return An immutable instance of State
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableState<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableState<>(value, onTearDown);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build State, some of required attributes are not set " + attributes;
    }
  }
}
