/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.jes;

import de.larssh.jes.JesException;
import de.larssh.jes.Job;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.net.ftp.FTPClient;

public class JesLimitReachedException
extends JesException {
    private final int limit;
    private final transient List<Job> jobs;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Mutability of jobs.outputs is not expected to be a problem for this exception")
    public JesLimitReachedException(int limit, List<Job> jobs, FTPClient ftpClient) {
        super(ftpClient, "Listing limit of %d reached.", limit);
        this.limit = limit;
        this.jobs = jobs;
    }

    public List<Job> getJobs() {
        return Collections.unmodifiableList(this.jobs);
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Override
    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "JesLimitReachedException(message=" + this.getMessage() + ", limit=" + this.getLimit() + ", jobs=" + this.getJobs() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JesLimitReachedException)) {
            return false;
        }
        JesLimitReachedException other = (JesLimitReachedException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JesLimitReachedException;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLimit();
        return result;
    }
}

