/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.jes;

import de.larssh.jes.JobFieldInconsistentException;
import de.larssh.jes.JobFlag;
import de.larssh.jes.JobOutput;
import de.larssh.jes.JobStatus;
import de.larssh.utils.OptionalInts;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import lombok.Generated;

public class Job {
    private final String id;
    private final String name;
    private final JobStatus status;
    private final String owner;
    private final Optional<String> jesClass;
    private final OptionalInt resultCode;
    private final Optional<String> abendCode;
    private final Set<JobFlag> flags;
    private final List<JobOutput> outputs = new ArrayList<JobOutput>();

    public Job(String jobId, String name, JobStatus status, String owner) {
        this(jobId, name, status, owner, Optional.empty(), OptionalInt.empty(), Optional.empty(), new JobFlag[0]);
    }

    public Job(String jobId, String name, JobStatus status, String owner, Optional<String> jesClass, OptionalInt resultCode, Optional<String> abendCode, JobFlag ... flags) {
        this.id = Strings.toUpperCaseNeutral((String)jobId.trim());
        this.name = Strings.toUpperCaseNeutral((String)name.trim());
        this.status = status;
        this.owner = Strings.toUpperCaseNeutral((String)owner.trim());
        this.jesClass = jesClass.map(String::trim).map(Strings::toUpperCaseNeutral);
        this.abendCode = abendCode.map(String::trim).map(Strings::toUpperCaseNeutral);
        this.resultCode = resultCode;
        this.flags = Collections.unmodifiableSet(new HashSet<JobFlag>(Arrays.asList(flags)));
        this.validate();
    }

    public JobOutput createOutput(int index, String outputName, int length, Optional<String> step, Optional<String> procedureStep, Optional<String> outputClass) {
        if (this.getStatus() != JobStatus.OUTPUT && this.getStatus() != JobStatus.ALL) {
            throw new JobFieldInconsistentException("Job outputs for status other than OUTPUT (and ALL) cannot be created. Status: %s", new Object[]{this.getStatus()});
        }
        JobOutput output = new JobOutput(this, index, outputName, length, step, procedureStep, outputClass);
        this.outputs.add(output);
        return output;
    }

    public Optional<JobOutput> getOutput(String name) {
        String trimmedName = name.trim();
        return this.getOutputs().stream().filter(output -> output.getName().equalsIgnoreCase(trimmedName)).findFirst();
    }

    public List<JobOutput> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    private void validate() {
        if (this.id.isEmpty()) {
            throw new JobFieldInconsistentException("Job ID must be filled, but is empty.", new Object[0]);
        }
        if (this.jesClass.filter(String::isEmpty).isPresent()) {
            throw new JobFieldInconsistentException("JES class must not be empty if present.", new Object[0]);
        }
        if (this.resultCode.isPresent() && this.abendCode.isPresent()) {
            throw new JobFieldInconsistentException("Result Code and Abend Code must not be present at the same time.", new Object[0]);
        }
        if (OptionalInts.filter((OptionalInt)this.resultCode, r -> r < 0).isPresent()) {
            throw new JobFieldInconsistentException("Result Code must not be less than zero.", new Object[0]);
        }
        if (this.abendCode.filter(String::isEmpty).isPresent()) {
            throw new JobFieldInconsistentException("Abend Code must not be empty if present.", new Object[0]);
        }
        if (this.status != JobStatus.OUTPUT && this.status != JobStatus.ALL) {
            if (this.resultCode.isPresent()) {
                throw new JobFieldInconsistentException(Strings.format((String)"Result Code must not be present for status [%s].", (Object[])new Object[]{this.status}), new Object[0]);
            }
            if (this.abendCode.isPresent()) {
                throw new JobFieldInconsistentException(Strings.format((String)"Abend Code must not be present for status [%s].", (Object[])new Object[]{this.status}), new Object[0]);
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getOwner() {
        return this.owner;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getJesClass() {
        return this.jesClass;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OptionalInt getResultCode() {
        return this.resultCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getAbendCode() {
        return this.abendCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<JobFlag> getFlags() {
        return this.flags;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Job(id=" + this.getId() + ", name=" + this.getName() + ", status=" + (Object)((Object)this.getStatus()) + ", owner=" + this.getOwner() + ", jesClass=" + this.getJesClass() + ", resultCode=" + this.getResultCode() + ", abendCode=" + this.getAbendCode() + ", flags=" + this.getFlags() + ", outputs=" + this.getOutputs() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Job;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

