/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.dtd;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLWriter;
import de.pdark.decentxml.dtd.DocTypeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocTypeEntity
extends BasicNode
implements DocTypeNode {
    private boolean parameterEntity;
    private String name;
    private char quoteChar = (char)34;
    private String text;
    private String resolvedText;
    private List<Node> nodes = new ArrayList<Node>();
    private String systemLiteral;
    private String publicIDLiteral;
    private String notationName;

    public DocTypeEntity(Token token, String name) {
        super(token);
        this.name = name;
    }

    public DocTypeEntity(XMLTokenizer.Type type, String name) {
        super(type, null);
        this.name = name;
    }

    public boolean isParameterEntity() {
        return this.parameterEntity;
    }

    public void setParameterEntity(boolean parameterEntity) {
        this.parameterEntity = parameterEntity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getResolvedText() {
        return this.resolvedText;
    }

    public void setResolvedText(String resolvedText) {
        this.resolvedText = resolvedText;
    }

    public String getSystemLiteral() {
        return this.systemLiteral;
    }

    public void setSystemLiteral(String systemLiteral) {
        this.systemLiteral = systemLiteral;
    }

    public boolean isSystem() {
        return this.systemLiteral != null;
    }

    public String getPublicIDLiteral() {
        return this.publicIDLiteral;
    }

    public void setPublicIDLiteral(String publicIDLiteral) {
        this.publicIDLiteral = publicIDLiteral;
    }

    public boolean isPublic() {
        return this.publicIDLiteral != null;
    }

    @Override
    public String getValue() {
        return this.toXML();
    }

    @Override
    public DocTypeEntity toXML(XMLWriter writer) throws IOException {
        writer.write(this, "<!ENTITY");
        if (this.nodes.isEmpty()) {
            if (this.isParameterEntity()) {
                writer.write(this, " %");
            }
            writer.write(this, this.name);
            writer.write(this, " ");
            writer.write(this, Character.toString(this.quoteChar));
            writer.write(this, this.text);
            writer.write(this, Character.toString(this.quoteChar));
            if (this.hasNDATA()) {
                writer.write(this, " ");
                writer.write(this, this.notationName);
            }
        } else {
            for (Node n : this.nodes) {
                n.toXML(writer);
            }
        }
        writer.write(this, ">");
        return this;
    }

    @Override
    public DocTypeEntity addNode(Node node) {
        this.nodes.add(node);
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public String getNotationName() {
        return this.notationName;
    }

    public void setNotationName(String notationName) {
        this.notationName = notationName;
    }

    public boolean hasNDATA() {
        return this.notationName != null;
    }
}

