/*
 * Decompiled with CFR 0.152.
 */
package de.swiesend.secretservice;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;

public class Static {
    public static final Duration DEFAULT_PROMPT_TIMEOUT = Duration.ofSeconds(120L);

    public static boolean isNullOrEmpty(CharSequence cs) {
        return cs == null || cs.toString().trim().isEmpty();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static class RFC_2409 {

        public static class SecondOakleyGroup {
            public static final byte[] PRIME = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1};
            public static final byte[] GENERATOR = new byte[]{2};
        }
    }

    public static class Convert {
        public static byte[] toByteArray(List<Byte> list) {
            byte[] result = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = list.get(i);
            }
            return result;
        }

        public static String toString(byte[] bytes) {
            return new String(bytes, StandardCharsets.UTF_8);
        }

        public static ObjectPath toObjectPath(String path) {
            return new ObjectPath("", path);
        }

        public static List<String> toStrings(List<ObjectPath> paths) {
            ArrayList<String> ps = new ArrayList<String>();
            for (ObjectPath p : paths) {
                ps.add(p.getPath());
            }
            return ps;
        }

        public static List<DBusPath> toDBusPaths(List<ObjectPath> paths) {
            ArrayList<DBusPath> ps = new ArrayList<DBusPath>();
            for (ObjectPath p : paths) {
                ps.add((DBusPath)p);
            }
            return ps;
        }
    }

    public static class Secret {
        public static final String GENERIC_TYPE = "org.freedesktop.Secret.Generic";
    }

    public static class Algorithm {
        public static final String PLAIN = "plain";
        public static final String DH_IETF1024_SHA256_AES128_CBC_PKCS7 = "dh-ietf1024-sha256-aes128-cbc-pkcs7";
        public static final String DIFFIE_HELLMAN = "DH";
        public static final String AES = "AES";
        public static final String AES_CBC_PKCS5 = "AES/CBC/PKCS5Padding";
        public static final String SHA1_PRNG = "SHA1PRNG";
    }

    public static class Interfaces {
        public static final String SERVICE = "org.freedesktop.Secret.Service";
        public static final String COLLECTION = "org.freedesktop.Secret.Collection";
        public static final String ITEM = "org.freedesktop.Secret.Item";
        public static final String SESSION = "org.freedesktop.Secret.Session";
        public static final String PROMPT = "org.freedesktop.Secret.Prompt";
    }

    public static class ObjectPaths {
        public static final String SECRETS = "/org/freedesktop/secrets";
        public static final String SESSION = "/org/freedesktop/secrets/session";
        public static final String ALIASES = "/org/freedesktop/secrets/aliases";
        public static final String DEFAULT_COLLECTION = "/org/freedesktop/secrets/aliases/default";
        public static final String COLLECTION = "/org/freedesktop/secrets/collection";
        public static final String SESSION_COLLECTION = "/org/freedesktop/secrets/collection/session";
        public static final String LOGIN_COLLECTION = "/org/freedesktop/secrets/collection/login";
        public static final String PROMPT = "/org/freedesktop/secrets/prompt";

        public static String collection(String name) {
            return "/org/freedesktop/secrets/collection/" + name;
        }

        public static String item(String collection, String item_id) {
            return "/org/freedesktop/secrets/collection/" + collection + "/" + item_id;
        }

        public static String session(String session_id) {
            return "/org/freedesktop/secrets/session/" + session_id;
        }

        public static String prompt(String window_id) {
            return "/org/freedesktop/secrets/prompt/" + window_id;
        }
    }

    public static class Service {
        public static final String SECRETS = "org.freedesktop.secrets";
    }

    public static class DBus {
        public static final Long DEFAULT_DELAY_MILLIS = 100L;
        public static final Long MAX_DELAY_MILLIS = 2000L;

        public static class Interfaces {
            public static final String DBUS = "org.freedesktop.DBus";
            public static final String DBUS_PROPERTIES = "org.freedesktop.DBus.Properties";
        }

        public static class ObjectPaths {
            public static final String DBUS = "/org/freedesktop/DBus";
        }

        public static class Service {
            public static final String DBUS = "org.freedesktop.DBus";
        }
    }
}

