/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.strategies.collections.sortedset;

import de.vandermeer.skb.interfaces.strategies.collections.IsSortedSetStrategy;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public interface TreeSetStrategy<T extends Comparable<T>>
extends IsSortedSetStrategy<TreeSet<T>, T> {
    @Override
    default public TreeSet<T> get(Collection<T> collection) {
        if (collection == null) {
            return new TreeSet();
        }
        TreeSet<T> ret = new TreeSet<T>();
        ret.addAll(collection);
        return ret;
    }

    @Override
    default public TreeSet<T> get(Collection<T> collection, Comparator<T> comparator) {
        if (collection == null) {
            return new TreeSet<T>(comparator);
        }
        TreeSet<T> ret = new TreeSet<T>();
        ret.addAll(collection);
        return ret;
    }

    @Override
    default public TreeSet<T> get() {
        return new TreeSet();
    }

    @Override
    default public TreeSet<T> get(Comparator<T> comparator) {
        return new TreeSet<T>(comparator);
    }

    public static <T extends Comparable<T>> TreeSetStrategy<T> create() {
        return new TreeSetStrategy<T>(){};
    }
}

