/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import java.util.function.Function;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationUtil {
    public static Authentication getSecurityHolderAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            return null;
        }
        return authentication;
    }

    public static Function<String, Boolean> getSecurityHolderRoleChecker() {
        Authentication authentication = AuthenticationUtil.getSecurityHolderAuthentication();
        if (authentication == null) {
            return role -> false;
        }
        return role -> authentication.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("ROLE_" + role));
    }
}

