/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import dev.hilla.ApplicationContextProvider;
import dev.hilla.EndpointController;
import dev.hilla.OpenAPIUtil;
import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.GeneratorProcessor;
import dev.hilla.engine.ParserProcessor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class EndpointCodeGenerator {
    private final EndpointController endpointController;
    private final VaadinContext context;
    private Path buildDirectory;
    private ApplicationConfiguration configuration;
    private String nodeExecutable;
    private Set<String> classesUsedInOpenApi = null;

    public EndpointCodeGenerator(VaadinContext context, EndpointController endpointController) {
        this.endpointController = endpointController;
        this.context = context;
    }

    public static EndpointCodeGenerator getInstance() {
        return (EndpointCodeGenerator)ApplicationContextProvider.getApplicationContext().getBean(EndpointCodeGenerator.class);
    }

    public void update() throws IOException {
        this.initIfNeeded();
        if (this.configuration.isProductionMode()) {
            throw new IllegalStateException("This method is not available in production mode");
        }
        EngineConfiguration engineConfiguration = EngineConfiguration.loadDirectory((Path)this.buildDirectory);
        ParserProcessor parser = new ParserProcessor(engineConfiguration, this.getClass().getClassLoader());
        parser.process();
        GeneratorProcessor generator = new GeneratorProcessor(engineConfiguration, this.nodeExecutable);
        generator.process();
        this.endpointController.registerEndpoints();
    }

    private void initIfNeeded() {
        if (this.configuration == null) {
            this.configuration = ApplicationConfiguration.get((VaadinContext)this.context);
            Path projectFolder = this.configuration.getProjectFolder().toPath();
            this.buildDirectory = projectFolder.resolve(this.configuration.getBuildFolder());
            FrontendTools tools = new FrontendTools(this.configuration, this.configuration.getProjectFolder());
            this.nodeExecutable = tools.getNodeBinary();
        }
    }

    public Set<String> getClassesUsedInOpenApi() throws IOException {
        if (this.classesUsedInOpenApi == null) {
            this.initIfNeeded();
            this.classesUsedInOpenApi = OpenAPIUtil.findOpenApiClasses(OpenAPIUtil.getCurrentOpenAPI(this.buildDirectory));
        }
        return this.classesUsedInOpenApi;
    }
}

