/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import dev.hilla.EndpointCodeGenerator;
import dev.hilla.EndpointController;
import dev.hilla.EndpointInvoker;
import dev.hilla.EndpointNameChecker;
import dev.hilla.EndpointProperties;
import dev.hilla.EndpointRegistry;
import dev.hilla.EndpointUtil;
import dev.hilla.ExplicitNullableTypeChecker;
import dev.hilla.auth.CsrfChecker;
import dev.hilla.auth.EndpointAccessChecker;
import dev.hilla.parser.jackson.JacksonObjectMapperFactory;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration
public class EndpointControllerConfiguration {
    private final EndpointProperties endpointProperties;

    public EndpointControllerConfiguration(EndpointProperties endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    AccessAnnotationChecker accessAnnotationChecker() {
        return new AccessAnnotationChecker();
    }

    @Bean
    EndpointAccessChecker accessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        return new EndpointAccessChecker(accessAnnotationChecker);
    }

    @Bean
    CsrfChecker csrfChecker(ServletContext servletContext) {
        return new CsrfChecker(servletContext);
    }

    @Bean
    EndpointInvoker endpointInvoker(ApplicationContext applicationContext, @Autowired(required=false) @Qualifier(value="endpointMapperFactory") JacksonObjectMapperFactory endpointMapperFactory, ExplicitNullableTypeChecker explicitNullableTypeChecker, ServletContext servletContext, EndpointRegistry endpointRegistry) {
        return new EndpointInvoker(applicationContext, endpointMapperFactory, explicitNullableTypeChecker, servletContext, endpointRegistry);
    }

    @Bean
    EndpointNameChecker endpointNameChecker() {
        return new EndpointNameChecker();
    }

    @Bean
    EndpointRegistry endpointRegistry(EndpointNameChecker endpointNameChecker) {
        return new EndpointRegistry(endpointNameChecker);
    }

    @Bean
    EndpointUtil endpointUtil() {
        return new EndpointUtil();
    }

    @Bean
    ExplicitNullableTypeChecker typeChecker() {
        return new ExplicitNullableTypeChecker();
    }

    @Bean
    WebMvcRegistrations webMvcRegistrationsHandlerMapping() {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
                return new RequestMappingHandlerMapping(){

                    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
                        if (EndpointController.class.equals(method.getDeclaringClass())) {
                            mapping = EndpointControllerConfiguration.this.prependEndpointPrefixUrl(mapping);
                        }
                        super.registerHandlerMethod(handler, method, mapping);
                    }
                };
            }
        };
    }

    private RequestMappingInfo prependEndpointPrefixUrl(RequestMappingInfo mapping) {
        RequestMappingInfo.Builder prefixMappingBuilder = RequestMappingInfo.paths((String[])new String[]{this.endpointProperties.getEndpointPrefix()});
        if (mapping.getPatternsCondition() == null) {
            RequestMappingInfo.BuilderConfiguration options = new RequestMappingInfo.BuilderConfiguration();
            options.setPatternParser(PathPatternParser.defaultInstance);
            prefixMappingBuilder.options(options);
        }
        return prefixMappingBuilder.build().combine(mapping);
    }

    @Bean
    EndpointCodeGenerator endpointCodeGenerator(ServletContext servletContext, EndpointController endpointController) {
        return new EndpointCodeGenerator((VaadinContext)new VaadinServletContext(servletContext), endpointController);
    }
}

