/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import dev.hilla.ConditionalOnFeatureFlag;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class FeatureFlagCondition
implements Condition {
    private FeatureFlags featureFlags = null;

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map annotationAttributes;
        if (context.getEnvironment().getProperty(FeatureFlagCondition.class.getName() + ".alwaysEnable") != null) {
            return true;
        }
        if (this.featureFlags == null) {
            this.featureFlags = this.getFeatureFlags(context);
        }
        if ((annotationAttributes = metadata.getAnnotationAttributes(ConditionalOnFeatureFlag.class.getName())) == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " can only be used through an @" + ConditionalOnFeatureFlag.class.getSimpleName() + " annotation and none was found");
        }
        String featureId = (String)annotationAttributes.get("value");
        return this.featureFlags.isEnabled(featureId);
    }

    private FeatureFlags getFeatureFlags(ConditionContext context) {
        final ClassLoader classLoader = Objects.requireNonNull(context.getClassLoader());
        ResourceProvider provider = new ResourceProvider(){

            public URL getApplicationResource(String path) {
                return classLoader.getResource(path);
            }

            public List<URL> getApplicationResources(String path) throws IOException {
                return Collections.list(classLoader.getResources(path));
            }

            public URL getClientResource(String path) {
                return this.getApplicationResource(path);
            }

            public InputStream getClientResourceAsStream(String path) throws IOException {
                return this.getClientResource(path).openStream();
            }
        };
        Lookup lookup = Lookup.of((Object)provider, (Class[])new Class[]{ResourceProvider.class});
        return new FeatureFlags(lookup);
    }
}

