/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class ShortCodec
extends AbstractPrimitiveCodec<Short> {
    ShortCodec(ByteBufAllocator allocator) {
        super(allocator, Short.TYPE, Short.class);
    }

    @Override
    public Short decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (binary) {
            boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
            switch (info.getType()) {
                case 2: 
                case 13: {
                    return value.readShortLE();
                }
            }
            if (isUnsigned) {
                return value.readUnsignedByte();
            }
            return value.readByte();
        }
        return (short)IntegerCodec.parse(value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Short;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        short v = (Short)value;
        if ((byte)v == v) {
            return new ByteCodec.ByteParameter(this.allocator, (byte)v);
        }
        return new ShortParameter(this.allocator, v);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        if (1 == type || 13 == type) {
            return true;
        }
        return 2 == type && (info.getDefinitions() & 0x20) == 0;
    }

    static final class ShortParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final short value;

        ShortParameter(ByteBufAllocator allocator, short value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                ByteBuf buf = this.allocator.buffer(2);
                try {
                    return buf.writeShortLE((int)this.value);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public short getType() {
            return 2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShortParameter)) {
                return false;
            }
            ShortParameter that = (ShortParameter)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

