/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import java.nio.ByteBuffer;
import net.gleamynode.netty2.MessageParseException;
import org.apache.mina.examples.sumup.AbstractMessage;

public class ResultMessage
extends AbstractMessage {
    private boolean ok;
    private int value;
    private boolean processedResultCode;

    public ResultMessage() {
        super(0);
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    protected boolean readBody(ByteBuffer buf) throws MessageParseException {
        if (!this.processedResultCode) {
            this.processedResultCode = this.readResultCode(buf);
            if (!this.processedResultCode) {
                return false;
            }
        }
        if (this.ok) {
            if (this.readValue(buf)) {
                this.processedResultCode = false;
                return true;
            }
            return false;
        }
        this.processedResultCode = false;
        return true;
    }

    private boolean readResultCode(ByteBuffer buf) {
        if (buf.remaining() < 2) {
            return false;
        }
        this.ok = buf.getShort() == 0;
        return true;
    }

    private boolean readValue(ByteBuffer buf) {
        if (buf.remaining() < 4) {
            return false;
        }
        this.value = buf.getInt();
        return true;
    }

    protected boolean writeBody(ByteBuffer buf) {
        if (buf.remaining() < 6) {
            return false;
        }
        buf.putShort((short)(!this.ok ? 1 : 0));
        if (this.ok) {
            buf.putInt(this.value);
        }
        return true;
    }

    public String toString() {
        if (this.ok) {
            return this.getSequence() + ":RESULT(" + this.value + ')';
        }
        return this.getSequence() + ":RESULT(ERROR)";
    }
}

