/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.examples.sumup.AddMessage;
import org.apache.mina.examples.sumup.ResultMessage;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;

public class ServerSessionHandler
implements ProtocolHandler {
    public void sessionOpened(ProtocolSession session) {
        System.out.println("OPENED");
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 60);
        session.setAttachment(new Integer(0));
    }

    public void sessionClosed(ProtocolSession session) {
        System.out.println("CLOSED");
    }

    public void messageReceived(ProtocolSession session, Object message) {
        System.out.println("RCVD: " + message);
        AddMessage am = (AddMessage)message;
        int sum = (Integer)session.getAttachment();
        int value = am.getValue();
        long expectedSum = (long)sum + (long)value;
        if (expectedSum > Integer.MAX_VALUE || expectedSum < Integer.MIN_VALUE) {
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(false);
            session.write(rm);
        } else {
            sum = (int)expectedSum;
            session.setAttachment(new Integer(sum));
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(true);
            rm.setValue(sum);
            session.write(rm);
        }
    }

    public void messageSent(ProtocolSession session, Object message) {
        System.out.println("SENT: " + message);
    }

    public void sessionIdle(ProtocolSession session, IdleStatus status) {
        System.out.println("Disconnecting the idle.");
        session.close();
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        cause.printStackTrace();
        session.close();
    }
}

