/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.filter;

import java.util.logging.Level;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoSession;
import org.apache.mina.util.SessionLog;

public class IoLoggingFilter
implements IoFilter {
    public static final String PREFIX = SessionLog.PREFIX;
    public static final String LOGGER = SessionLog.LOGGER;
    private Level defaultLevel = Level.INFO;

    public Level getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(Level defaultLevel) {
        if (defaultLevel == null) {
            defaultLevel = Level.INFO;
        }
        this.defaultLevel = defaultLevel;
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        SessionLog.log(this.defaultLevel, session, "OPENED");
        nextFilter.sessionOpened(session);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        SessionLog.log(this.defaultLevel, session, "CLOSED");
        nextFilter.sessionClosed(session);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        SessionLog.log(this.defaultLevel, session, "IDLE: " + status);
        nextFilter.sessionIdle(session, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        SessionLog.log(this.defaultLevel, session, "EXCEPTION:", cause);
        nextFilter.exceptionCaught(session, cause);
    }

    public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) {
        SessionLog.log(this.defaultLevel, session, "READ: " + buf.getHexDump());
        nextFilter.dataRead(session, buf);
    }

    public void dataWritten(IoFilter.NextFilter nextFilter, IoSession session, Object marker) {
        SessionLog.log(this.defaultLevel, session, "WRITTEN: " + marker);
        nextFilter.dataWritten(session, marker);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf, Object marker) {
        SessionLog.log(this.defaultLevel, session, "WRITE: " + marker + ", " + buf.getHexDump());
        nextFilter.filterWrite(session, buf, marker);
    }
}

