/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.BaseSessionManager;
import org.apache.mina.io.IoAcceptor;
import org.apache.mina.io.IoFilterChain;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSessionManagerFilterChain;
import org.apache.mina.io.socket.SocketIoProcessor;
import org.apache.mina.io.socket.SocketSession;
import org.apache.mina.io.socket.SocketSessionManagerFilterChain;
import org.apache.mina.util.Queue;

public class SocketAcceptor
extends BaseSessionManager
implements IoAcceptor {
    private static volatile int nextId = 0;
    private final IoSessionManagerFilterChain filters = new SocketSessionManagerFilterChain(this);
    private final int id = nextId++;
    private final Selector selector;
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private int backlog = 50;
    private Worker worker;

    public SocketAcceptor() throws IOException {
        this.selector = Selector.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (((InetSocketAddress)address).getPort() == 0) {
            throw new IllegalArgumentException("Unsupported port number: 0");
        }
        RegistrationRequest request = new RegistrationRequest(address, this.backlog, handler);
        Object object = this;
        synchronized (object) {
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            throw request.exception;
        }
    }

    private synchronized void startupWorker() {
        if (this.worker == null) {
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        Object object = this;
        synchronized (object) {
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                this.cancelQueue.push(request);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            request.exception.fillInStackTrace();
            throw request.exception;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int defaultBacklog) {
        if (defaultBacklog <= 0) {
            throw new IllegalArgumentException("defaultBacklog: " + defaultBacklog);
        }
        this.backlog = defaultBacklog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            ServerSocketChannel ssc = null;
            try {
                ssc = ServerSocketChannel.open();
                ssc.configureBlocking(false);
                ssc.socket().bind(req.address, req.backlog);
                ssc.register(this.selector, 16, req);
                this.channels.put(req.address, ssc);
                continue;
            }
            catch (IOException e) {
                req.exception = e;
                continue;
            }
            finally {
                RegistrationRequest e = req;
                synchronized (e) {
                    req.done = true;
                    req.notify();
                }
                if (ssc == null || req.exception == null) continue;
                try {
                    ssc.close();
                }
                catch (IOException e2) {
                    this.exceptionMonitor.exceptionCaught(this, e2);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            CancellationRequest request;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                request = (CancellationRequest)this.cancelQueue.pop();
            }
            if (request == null) return;
            ServerSocketChannel ssc = (ServerSocketChannel)this.channels.remove(request.address);
            try {
                if (ssc == null) {
                    request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    continue;
                }
                SelectionKey key = ssc.keyFor(this.selector);
                key.cancel();
                this.selector.wakeup();
                ssc.close();
                continue;
            }
            catch (IOException e) {
                this.exceptionMonitor.exceptionCaught(this, e);
                continue;
            }
            finally {
                CancellationRequest cancellationRequest = request;
                synchronized (cancellationRequest) {
                    request.done = true;
                    request.notify();
                }
                continue;
            }
            break;
        }
    }

    public IoFilterChain getFilterChain() {
        return this.filters;
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private final SocketAddress address;
        private final int backlog;
        private final IoHandler handler;
        private IOException exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, int backlog, IoHandler handler) {
            this.address = address;
            this.backlog = backlog;
            this.handler = handler;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("SocketAcceptor-" + SocketAcceptor.this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = SocketAcceptor.this.selector.select();
                        SocketAcceptor.this.registerNew();
                        SocketAcceptor.this.cancelKeys();
                        if (nKeys <= 0) continue;
                        this.processSessions(SocketAcceptor.this.selector.selectedKeys());
                    } while (!SocketAcceptor.this.selector.keys().isEmpty());
                    SocketAcceptor socketAcceptor = SocketAcceptor.this;
                    synchronized (socketAcceptor) {
                        if (SocketAcceptor.this.selector.keys().isEmpty() && SocketAcceptor.this.registerQueue.isEmpty() && SocketAcceptor.this.cancelQueue.isEmpty()) {
                            SocketAcceptor.this.worker = null;
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    SocketAcceptor.this.exceptionMonitor.exceptionCaught(SocketAcceptor.this, e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSessions(Set keys) throws IOException {
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                ServerSocketChannel ssc;
                SocketChannel ch;
                SelectionKey key = (SelectionKey)it.next();
                it.remove();
                if (!key.isAcceptable() || (ch = (ssc = (ServerSocketChannel)key.channel()).accept()) == null) continue;
                boolean success = false;
                try {
                    RegistrationRequest req = (RegistrationRequest)key.attachment();
                    SocketSession session = new SocketSession(SocketAcceptor.this.filters, ch, req.handler);
                    req.handler.sessionCreated(session);
                    SocketIoProcessor.getInstance().addSession(session);
                    success = true;
                }
                catch (Throwable t) {
                    SocketAcceptor.this.exceptionMonitor.exceptionCaught(SocketAcceptor.this, t);
                }
                finally {
                    if (success) continue;
                    ch.close();
                }
            }
        }
    }
}

