/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.asn1.ber.digester.BERDigester;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.asn1.codec.stateful.StatefulDecoder;
import org.apache.ldap.common.berlib.asn1.decoder.LdapDigesterFactory;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderDecoder;
import org.apache.ldap.common.message.spi.ProviderException;

public class SnickersDecoder
implements ProviderDecoder {
    private final Provider provider;
    private final BERDigester digester;

    public SnickersDecoder(Provider provider) {
        this.provider = provider;
        LdapDigesterFactory factory = LdapDigesterFactory.getSingleton();
        this.digester = factory.create();
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void decode(Object encoded) throws DecoderException {
        ByteBuffer buf = null;
        if (encoded instanceof ByteBuffer) {
            buf = (ByteBuffer)encoded;
        } else if (encoded instanceof byte[]) {
            buf = ByteBuffer.wrap((byte[])encoded);
        } else {
            throw new DecoderException("Expected either a byte[] or ByteBuffer argument but got a " + encoded.getClass());
        }
        this.digester.decode((Object)buf);
    }

    public void setCallback(DecoderCallback cb) {
        this.digester.setCallback(cb);
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
        this.digester.setDecoderMonitor(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws ProviderException {
        LdapDigesterFactory factory = LdapDigesterFactory.getSingleton();
        BERDigester digesterTmp = factory.create();
        DigesterCallback dcb = new DigesterCallback();
        digesterTmp.setCallback((DecoderCallback)dcb);
        if (lock == null) {
            this.digest(digesterTmp, in);
            return dcb.getMessage();
        }
        try {
            Object object = lock;
            synchronized (object) {
                this.digest(digesterTmp, in);
                lock.notifyAll();
            }
        }
        catch (Exception e) {
            ProviderException pe = new ProviderException(this.provider, "Snickers decoder failure!");
            pe.addThrowable((Throwable)e);
            throw pe;
        }
        return dcb.getMessage();
    }

    private void digest(BERDigester digesterTmp, InputStream in) throws ProviderException {
        byte[] buf = null;
        try {
            int amount = -1;
            while (in.available() > 0 && (amount = in.read(buf = new byte[in.available()])) != -1) {
                digesterTmp.decode((Object)ByteBuffer.wrap(buf, 0, amount));
            }
        }
        catch (Exception e) {
            ProviderException pe = new ProviderException(this.provider, "Snickers decoder failure!");
            pe.addThrowable((Throwable)e);
            throw pe;
        }
    }

    class DigesterCallback
    implements DecoderCallback {
        private Message msg;

        DigesterCallback() {
        }

        public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
            this.msg = (Message)decoded;
        }

        Message getMessage() throws ProviderException {
            if (this.msg == null) {
                throw new ProviderException(SnickersDecoder.this.provider, "Callback did not receive a message as expected from the Snickers BERDigester");
            }
            Message tmp = this.msg;
            this.msg = null;
            return tmp;
        }
    }
}

