/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.modify;

import java.nio.ByteBuffer;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.digester.rules.PrimitiveOctetStringRule;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.ModifyRequest;

public class ModificationItemRule
extends PrimitiveOctetStringRule {
    public ModificationItemRule() {
        super((TagEnum)UniversalTag.OCTET_STRING);
    }

    public void finish() {
        if (this.isConstructed()) {
            return;
        }
        ByteBuffer buf = this.getAccumulator().drain(0);
        byte[] octets = null;
        if (buf.limit() == buf.capacity() && buf.hasArray()) {
            octets = buf.array();
        } else {
            octets = new byte[buf.remaining()];
            buf.get(octets);
        }
        int op = this.getDigester().popInt();
        int modCode = -1;
        switch (op) {
            case 0: {
                modCode = 1;
                break;
            }
            case 1: {
                modCode = 3;
                break;
            }
            case 2: {
                modCode = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Expecting 0, 1, 2 int value for add, delete, or replace operation on entry attribute but got a " + op);
            }
        }
        LockableAttributeImpl attr = new LockableAttributeImpl(new String(octets));
        ModifyRequest req = (ModifyRequest)this.getDigester().peek();
        ModificationItem mods = new ModificationItem(modCode, (Attribute)attr);
        req.addModification(mods);
        this.getDigester().push((Object)mods);
        this.setConstructed(false);
    }
}

