/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import org.apache.asn1.codec.DecoderException;

public class Length {
    public static final int INDEFINITE = -2;
    public static final int UNDEFINED = -1;
    public static final int END_MASK = 128;
    private int value = -1;
    private int numOctets = -1;
    private boolean isFixated = false;
    private final ByteBuffer buf = ByteBuffer.allocate(5);

    public boolean isFixated() {
        return this.isFixated;
    }

    void clear() {
        this.isFixated = false;
        this.value = 0;
        this.numOctets = 1;
        this.buf.clear();
    }

    void fixate() throws DecoderException {
        this.buf.flip();
        this.value = Length.getLength(this.buf);
        this.isFixated = true;
    }

    void add(byte octet) throws DecoderException {
        if (this.isFixated) {
            throw new IllegalStateException("data added to fixated length");
        }
        this.buf.put(octet);
        if (this.buf.position() == 1) {
            if (128 == (octet & 0x80)) {
                int typeLength = octet & 0x7F;
                if (typeLength == 0) {
                    this.numOctets = -2;
                    this.fixate();
                } else {
                    if (typeLength == 127) {
                        throw new DecoderException("The number of octets must not be 127 (reserved for future extension) ");
                    }
                    this.numOctets = octet & 0x7F;
                }
            } else {
                this.fixate();
            }
        } else if (this.buf.position() >= this.numOctets + 1) {
            this.fixate();
        }
    }

    public int getLength() {
        return this.value;
    }

    public int size() {
        return this.buf.position();
    }

    public static int getLength(ByteBuffer octets) throws DecoderException {
        if (octets.remaining() >= 6) {
            throw new DecoderException("Length number is too large.");
        }
        byte octet = octets.get();
        if ((octet & 0x80) == 0) {
            return octet;
        }
        if ((octet & 0x7F) == 0) {
            return -2;
        }
        int length = 0;
        int ii = octets.remaining();
        int shift = ii - 1 << 3;
        while (ii > 0) {
            length |= (0xFF & octets.get()) << shift;
            --ii;
            shift -= 8;
        }
        return length;
    }
}

