/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.digester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.asn1.ber.digester.Rule;

public class TagNode {
    private Integer tag;
    private int depth;
    private HashMap children = new HashMap(3);
    private ArrayList rules = new ArrayList(3);

    TagNode(Integer tag) {
        this.tag = tag;
    }

    void addNode(TagNode node) {
        this.children.put(node.getTag(), node);
        node.setDepth(this.depth + 1);
    }

    void addRule(Rule rule) {
        this.rules.add(rule);
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    public Integer getTag() {
        return this.tag;
    }

    public int getDepth() {
        return this.depth;
    }

    public List getRules() {
        return this.rules;
    }

    public boolean hasChild(Integer tag) {
        return this.children.containsKey(tag);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Iterator getChildren() {
        return this.children.values().iterator();
    }

    public TagNode getChild(Integer tag) {
        return (TagNode)this.children.get(tag);
    }
}

