/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.crypto.checksum;

import java.util.zip.CRC32;
import org.apache.kerberos.crypto.checksum.ChecksumEngine;
import org.apache.kerberos.crypto.checksum.ChecksumType;
import org.apache.kerberos.crypto.encryption.CipherType;
import org.bouncycastle.crypto.Digest;

public class Crc32Checksum
extends ChecksumEngine {
    public Digest getDigest() {
        return new CRC32Digest();
    }

    public ChecksumType checksumType() {
        return ChecksumType.CRC32;
    }

    public CipherType keyType() {
        return CipherType.NULL;
    }

    public int checksumSize() {
        return 4;
    }

    public int keySize() {
        return 0;
    }

    public int confounderSize() {
        return 0;
    }

    public boolean isSafe() {
        return false;
    }

    public byte[] calculateKeyedChecksum(byte[] data, byte[] key) {
        return null;
    }

    public boolean verifyKeyedChecksum(byte[] data, byte[] key, byte[] checksum) {
        return false;
    }

    private class CRC32Digest
    implements Digest {
        private CRC32 crc32 = new CRC32();

        private CRC32Digest() {
        }

        public String getAlgorithmName() {
            return "CRC-32";
        }

        public int getDigestSize() {
            return 4;
        }

        public void reset() {
            this.crc32.reset();
        }

        public void update(byte in) {
            this.crc32.update(in);
        }

        public void update(byte[] in, int inOff, int len) {
            this.crc32.update(in, inOff, len);
        }

        public int doFinal(byte[] out, int outOff) {
            out = this.int2octet((int)this.crc32.getValue());
            return 0;
        }

        private byte[] int2octet(int value) {
            byte[] bytes = new byte[4];
            int i = 0;
            int shift = 24;
            while (i < 4) {
                bytes[i] = (byte)(0xFF & value >> shift);
                ++i;
                shift -= 8;
            }
            return bytes;
        }
    }
}

