/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asn1.der.ASN1OutputStream;
import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.encoder.HostAddressesEncoder;
import org.apache.kerberos.io.encoder.KerberosTimeEncoder;
import org.apache.kerberos.messages.components.EncKrbPrivPart;

public class EncKrbPrivPartEncoder {
    private static final int APPLICATION_CODE = 28;

    public byte[] encode(EncKrbPrivPart privPart) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence privPartSequence = this.encodePrivatePartSequence(privPart);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)28, (DEREncodable)privPartSequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodePrivatePartSequence(EncKrbPrivPart message) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DEROctetString(message.getUserData())));
        if (message.getTimestamp() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)KerberosTimeEncoder.encode(message.getTimestamp())));
        }
        if (message.getMicroSecond() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)DERInteger.valueOf((int)message.getMicroSecond())));
        }
        if (message.getSequenceNumber() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)DERInteger.valueOf((int)message.getSequenceNumber())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)HostAddressesEncoder.encode(message.getSenderAddress())));
        if (message.getRecipientAddress() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)HostAddressesEncoder.encode(message.getRecipientAddress())));
        }
        return sequence;
    }
}

