/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asn1.der.ASN1OutputStream;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.messages.value.PreAuthenticationData;

public class PreAuthenticationDataEncoder {
    public static byte[] encode(PreAuthenticationData[] preAuth) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)PreAuthenticationDataEncoder.encodeSequence(preAuth));
        aos.close();
        return baos.toByteArray();
    }

    protected static DERSequence encodeSequence(PreAuthenticationData[] preAuth) {
        DERSequence sequence = new DERSequence();
        for (int ii = 0; ii < preAuth.length; ++ii) {
            sequence.add((DEREncodable)PreAuthenticationDataEncoder.encode(preAuth[ii]));
        }
        return sequence;
    }

    protected static DERSequence encode(PreAuthenticationData preAuth) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)preAuth.getDataType().getOrdinal())));
        if (preAuth.getDataValue() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)new DEROctetString(preAuth.getDataValue())));
        }
        return sequence;
    }
}

