/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.value;

import java.util.Date;

public class KerberosTime
implements Comparable {
    public static final KerberosTime INFINITY = new KerberosTime(Long.MAX_VALUE);
    private long _localTime;

    public KerberosTime() {
        Date temp = new Date();
        this._localTime = temp.getTime();
    }

    public KerberosTime(long time) {
        this._localTime = time;
    }

    public KerberosTime(Date time) {
        this._localTime = time.getTime();
    }

    public int compareTo(Object o) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == o) {
            return 0;
        }
        KerberosTime that = (KerberosTime)o;
        if (this._localTime < that._localTime) {
            return -1;
        }
        if (this._localTime > that._localTime) {
            return 1;
        }
        return 0;
    }

    public long getTime() {
        return this._localTime;
    }

    public Date toDate() {
        return new Date(this._localTime);
    }

    public boolean isInClockSkew(long clockSkew) {
        KerberosTime now = new KerberosTime();
        return Math.abs(this._localTime - now._localTime) < clockSkew;
    }

    public boolean greaterThan(KerberosTime time) {
        return this._localTime > time._localTime;
    }

    public boolean lessThan(KerberosTime time) {
        return this._localTime < time._localTime;
    }

    public boolean equals(KerberosTime time) {
        return this._localTime == time._localTime;
    }

    public boolean isZero() {
        return this._localTime == 0L;
    }
}

