/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1;

import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.primitives.ContextSpecificTag;

public class LdapTag
extends TagEnum {
    private static final int BIND_REQUEST_TAG = 0x60000000;
    private static final int BIND_RESPONSE_TAG = 0x41000000;
    private static final int UNBIND_REQUEST_TAG = 0x42000000;
    private static final int SEARCH_REQUEST_TAG = 0x63000000;
    private static final int SEARCH_RESULT_ENTRY_TAG = 0x64000000;
    private static final int SEARCH_RESULT_DONE_TAG = 0x65000000;
    private static final int SEARCH_RESULT_REFERENCE_TAG = 0x73000000;
    private static final int MODIFY_REQUEST_TAG = 0x66000000;
    private static final int MODIFY_RESPONSE_TAG = 0x67000000;
    private static final int ADD_REQUEST_TAG = 0x68000000;
    private static final int ADD_RESPONSE_TAG = 0x69000000;
    private static final int DEL_REQUEST_TAG = 0x4A000000;
    private static final int DEL_RESPONSE_TAG = 0x6B000000;
    private static final int MODIFYDN_REQUEST_TAG = 0x6C000000;
    private static final int MODIFYDN_RESPONSE_TAG = 0x6D000000;
    private static final int COMPARE_REQUEST_TAG = 0x6E000000;
    private static final int COMPARE_RESPONSE_TAG = 0x6F000000;
    private static final int ABANDON_REQUEST_TAG = 0x50000000;
    private static final int EXTENDED_REQUEST_TAG = 0x77000000;
    private static final int EXTENDED_RESPONSE_TAG = 0x78000000;
    static final int BIND_REQUEST_ID = 0;
    static final int BIND_RESPONSE_ID = 1;
    static final int UNBIND_REQUEST_ID = 2;
    static final int SEARCH_REQUEST_ID = 3;
    static final int SEARCH_RESULT_ENTRY_ID = 4;
    static final int SEARCH_RESULT_DONE_ID = 5;
    static final int SEARCH_RESULT_REFERENCE_ID = 19;
    static final int MODIFY_REQUEST_ID = 6;
    static final int MODIFY_RESPONSE_ID = 7;
    static final int ADD_REQUEST_ID = 8;
    static final int ADD_RESPONSE_ID = 9;
    static final int DEL_REQUEST_ID = 10;
    static final int DEL_RESPONSE_ID = 11;
    static final int MODIFYDN_REQUEST_ID = 12;
    static final int MODIFYDN_RESPONSE_ID = 13;
    static final int COMPARE_REQUEST_ID = 14;
    static final int COMPARE_RESPONSE_ID = 15;
    static final int ABANDON_REQUEST_ID = 16;
    static final int EXTENDED_REQUEST_ID = 23;
    static final int EXTENDED_RESPONSE_ID = 24;
    public static final LdapTag BIND_REQUEST = new LdapTag("BIND_REQUEST", 0x60000000, 0);
    public static final LdapTag BIND_RESPONSE = new LdapTag("BIND_RESPONSE", 0x41000000, 1);
    public static final LdapTag UNBIND_REQUEST = new LdapTag("UNBIND_REQUEST", 0x42000000, 2);
    public static final LdapTag SEARCH_REQUEST = new LdapTag("SEARCH_REQUEST", 0x63000000, 3);
    public static final LdapTag SEARCH_RESULT_DONE = new LdapTag("SEARCH_RESULT_DONE", 0x65000000, 5);
    public static final LdapTag SEARCH_RESULT_ENTRY = new LdapTag("SEARCH_RESULT_ENTRY", 0x64000000, 4);
    public static final LdapTag SEARCH_RESULT_REFERENCE = new LdapTag("SEARCH_RESULT_REFERENCE", 0x73000000, 19);
    public static final LdapTag MODIFY_REQUEST = new LdapTag("MODIFY_REQUEST", 0x66000000, 6);
    public static final LdapTag MODIFY_RESPONSE = new LdapTag("MODIFY_RESPONSE", 0x67000000, 7);
    public static final LdapTag ADD_REQUEST = new LdapTag("ADD_REQUEST", 0x68000000, 8);
    public static final LdapTag ADD_RESPONSE = new LdapTag("ADD_RESPONSE", 0x69000000, 9);
    public static final LdapTag DEL_REQUEST = new LdapTag("DEL_REQUEST", 0x4A000000, 10);
    public static final LdapTag DEL_RESPONSE = new LdapTag("DEL_RESPONSE", 0x6B000000, 11);
    public static final LdapTag MODIFYDN_REQUEST = new LdapTag("MODIFYDN_REQUEST", 0x6C000000, 12);
    public static final LdapTag MODIFYDN_RESPONSE = new LdapTag("MODIFYDN_RESPONSE", 0x6D000000, 13);
    public static final LdapTag COMPARE_REQUEST = new LdapTag("COMPARE_REQUEST", 0x6E000000, 14);
    public static final LdapTag COMPARE_RESPONSE = new LdapTag("COMPARE_RESPONSE", 0x6F000000, 15);
    public static final LdapTag ABANDON_REQUEST = new LdapTag("ABANDON_REQUEST", 0x50000000, 16);
    public static final LdapTag EXTENDED_REQUEST = new LdapTag("EXTENDED_REQUEST", 0x77000000, 23);
    public static final LdapTag EXTENDED_RESPONSE = new LdapTag("EXTENDED_RESPONSE", 0x78000000, 24);
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_11 = new ContextSpecificTag(11, true);
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_10 = new ContextSpecificTag(10, true);
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_8 = new ContextSpecificTag(8, true);
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_7 = new ContextSpecificTag(7, true);
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_6 = new ContextSpecificTag(6, true);
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_5;
    public static final ContextSpecificTag GREATER_OR_EQUAL_TAG;
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_3;
    public static final ContextSpecificTag REFERRAL_TAG;
    public static final ContextSpecificTag SERVER_SASL_CREDS_TAG;
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_0;
    public static final ContextSpecificTag EXTENDED_REQUEST_NAME_TAG;
    public static final ContextSpecificTag EXTENDED_RESPONSE_NAME_TAG;
    public static final ContextSpecificTag EXTENDED_RESPONSE_VALUE_TAG;
    public static final ContextSpecificTag MODIFYDN_REQUEST_NEWSUP_TAG;
    public static final ContextSpecificTag SEARCH_REQUEST_EQUALITY_MATH_TAG;
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_4;
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_1;
    public static final ContextSpecificTag EXTENDED_REQUEST_VALUE_TAG;
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_2;
    public static final ContextSpecificTag CONTEXT_SPECIFIC_TAG_9;

    private LdapTag(String name, int value, int id) {
        super(name, value, id);
    }

    public static LdapTag getLdapTag(int value) {
        LdapTag type = null;
        switch (value) {
            case 0x60000000: {
                type = BIND_REQUEST;
                break;
            }
            case 0x41000000: {
                type = BIND_RESPONSE;
                break;
            }
            case 0x42000000: {
                type = UNBIND_REQUEST;
                break;
            }
            case 0x63000000: {
                type = SEARCH_REQUEST;
                break;
            }
            case 0x64000000: {
                type = SEARCH_RESULT_ENTRY;
                break;
            }
            case 0x65000000: {
                type = SEARCH_RESULT_DONE;
                break;
            }
            case 0x73000000: {
                type = SEARCH_RESULT_REFERENCE;
                break;
            }
            case 0x66000000: {
                type = MODIFY_REQUEST;
                break;
            }
            case 0x67000000: {
                type = MODIFY_RESPONSE;
                break;
            }
            case 0x68000000: {
                type = ADD_REQUEST;
                break;
            }
            case 0x69000000: {
                type = ADD_RESPONSE;
                break;
            }
            case 0x4A000000: {
                type = DEL_REQUEST;
                break;
            }
            case 0x6B000000: {
                type = DEL_RESPONSE;
                break;
            }
            case 0x6C000000: {
                type = MODIFYDN_REQUEST;
                break;
            }
            case 0x6D000000: {
                type = MODIFYDN_RESPONSE;
                break;
            }
            case 0x6E000000: {
                type = COMPARE_REQUEST;
                break;
            }
            case 0x6F000000: {
                type = COMPARE_RESPONSE;
                break;
            }
            case 0x50000000: {
                type = ABANDON_REQUEST;
                break;
            }
            case 0x77000000: {
                type = EXTENDED_REQUEST;
                break;
            }
            case 0x78000000: {
                type = EXTENDED_RESPONSE;
                break;
            }
            default: {
                String msg = value < 10000 && value > -1 ? "Looks like you're using an id instead of a tag" : "Tag value of " + value + " not recognized";
                throw new IllegalArgumentException(msg);
            }
        }
        return type;
    }

    public static LdapTag getLdapTagById(int id) {
        LdapTag type = null;
        switch (id) {
            case 0: {
                type = BIND_REQUEST;
                break;
            }
            case 1: {
                type = BIND_RESPONSE;
                break;
            }
            case 2: {
                type = UNBIND_REQUEST;
                break;
            }
            case 3: {
                type = SEARCH_REQUEST;
                break;
            }
            case 4: {
                type = SEARCH_RESULT_ENTRY;
                break;
            }
            case 5: {
                type = SEARCH_RESULT_DONE;
                break;
            }
            case 19: {
                type = SEARCH_RESULT_REFERENCE;
                break;
            }
            case 6: {
                type = MODIFY_REQUEST;
                break;
            }
            case 7: {
                type = MODIFY_RESPONSE;
                break;
            }
            case 8: {
                type = ADD_REQUEST;
                break;
            }
            case 9: {
                type = ADD_RESPONSE;
                break;
            }
            case 10: {
                type = DEL_REQUEST;
                break;
            }
            case 11: {
                type = DEL_RESPONSE;
                break;
            }
            case 12: {
                type = MODIFYDN_REQUEST;
                break;
            }
            case 13: {
                type = MODIFYDN_RESPONSE;
                break;
            }
            case 14: {
                type = COMPARE_REQUEST;
                break;
            }
            case 15: {
                type = COMPARE_RESPONSE;
                break;
            }
            case 16: {
                type = ABANDON_REQUEST;
                break;
            }
            case 23: {
                type = EXTENDED_REQUEST;
                break;
            }
            case 24: {
                type = EXTENDED_RESPONSE;
                break;
            }
            default: {
                String msg = id > 10000 || id < 0 ? "Looks like you're using a tag instead of an id" : "Id of " + id + " not recognized as a LDAPv3 id";
                throw new IllegalArgumentException(msg);
            }
        }
        return type;
    }

    static {
        GREATER_OR_EQUAL_TAG = CONTEXT_SPECIFIC_TAG_5 = new ContextSpecificTag(5, true);
        REFERRAL_TAG = CONTEXT_SPECIFIC_TAG_3 = new ContextSpecificTag(3, true);
        SERVER_SASL_CREDS_TAG = CONTEXT_SPECIFIC_TAG_7;
        EXTENDED_REQUEST_NAME_TAG = CONTEXT_SPECIFIC_TAG_0 = new ContextSpecificTag(0, false);
        EXTENDED_RESPONSE_NAME_TAG = new ContextSpecificTag(10, false);
        EXTENDED_RESPONSE_VALUE_TAG = new ContextSpecificTag(11, false);
        MODIFYDN_REQUEST_NEWSUP_TAG = CONTEXT_SPECIFIC_TAG_0;
        SEARCH_REQUEST_EQUALITY_MATH_TAG = CONTEXT_SPECIFIC_TAG_3;
        CONTEXT_SPECIFIC_TAG_4 = new ContextSpecificTag(4, true);
        EXTENDED_REQUEST_VALUE_TAG = CONTEXT_SPECIFIC_TAG_1 = new ContextSpecificTag(1, true);
        CONTEXT_SPECIFIC_TAG_2 = new ContextSpecificTag(2, true);
        CONTEXT_SPECIFIC_TAG_9 = new ContextSpecificTag(9, true);
    }
}

