/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.asn1.ber.primitives.PrimitiveUtils;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchRequestProcessing;
import org.apache.ldap.common.message.SearchRequestImpl;

public class TypesOnlyRule
extends AbstractRule {
    private byte value = 0;
    private boolean octetSet = false;
    private final TagEnum tag = UniversalTag.BOOLEAN;

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        if (id != this.tag.getTagId()) {
            throw new IllegalArgumentException("Expecting " + this.tag.getName() + " with an id of " + this.tag.getTagId() + " but instead got a tag id of " + id);
        }
    }

    public void length(int length) {
        if (length != 1) {
            throw new IllegalArgumentException("The target primitive for this rule only requires a single octet with a length of 1.  The length of the field however is " + length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.octetSet) {
            throw new IllegalArgumentException("The target primitive for this rule only requires a single octet with a length of 1.  That octet has already been set.");
        }
        while (buf.hasRemaining()) {
            this.value = buf.get();
            this.octetSet = true;
        }
    }

    public void finish() {
        SearchRequestImpl req = (SearchRequestImpl)this.getDigester().peek(1);
        req.setTypesOnly(PrimitiveUtils.berDecodeBoolean(this.value));
        ((SearchRequestProcessing)this.getDigester().peek()).next();
        this.value = 0;
        this.octetSet = false;
    }
}

