/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder;

import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;
import org.apache.ldap.common.berlib.asn1.encoder.ReferralEncoder;
import org.apache.ldap.common.message.LdapResult;

public class LdapResultEncoder {
    public static final LdapResultEncoder INSTANCE = new LdapResultEncoder();

    public void encode(DefaultMutableTupleNode top, LdapResult result) {
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)UniversalTag.ENUMERATED, result.getResultCode().getValue());
        top.addLast(child);
        child.setParent(top);
        child = result.getMatchedDn() == null ? (DefaultMutableTupleNode)EncoderUtils.encode("") : (DefaultMutableTupleNode)EncoderUtils.encode(result.getMatchedDn());
        top.addLast(child);
        child.setParent(top);
        if (result.getErrorMessage() != null) {
            child = (DefaultMutableTupleNode)EncoderUtils.encode(result.getErrorMessage());
            top.addLast(child);
            child.setParent(top);
        } else {
            child = (DefaultMutableTupleNode)EncoderUtils.encode("");
            top.addLast(child);
            child.setParent(top);
        }
        if (result.getReferral() != null && result.getReferral().getLdapUrls().size() > 0) {
            child = (DefaultMutableTupleNode)ReferralEncoder.INSTANCE.encode(result.getReferral());
            top.addLast(child);
            child.setParent(top);
        }
    }
}

