/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.schema;

import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.ldap.common.name.DnParser;
import org.apache.ldap.common.schema.SyntaxChecker;

public class DnSyntaxChecker
implements SyntaxChecker {
    private final String oid;
    private NameParser parser;

    public DnSyntaxChecker(String oid) throws NamingException {
        this.oid = oid;
        this.parser = new DnParser();
    }

    public String getSyntaxOid() {
        return this.oid;
    }

    public boolean isValidSyntax(Object value) {
        if (value instanceof Name) {
            return true;
        }
        if (value instanceof String) {
            try {
                this.parser.parse((String)value);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void assertSyntax(Object value) throws NamingException {
        if (value instanceof Name) {
            return;
        }
        if (value instanceof String) {
            this.parser.parse((String)value);
        }
        throw new NamingException("Do not know how syntax check instances of " + value.getClass());
    }
}

