/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.common.util.StringTools;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexEnumeration;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.regexp.RE;

public class IndexDialog
extends JDialog {
    private static final long serialVersionUID = 3689917253680445238L;
    public static final String DEFAULT_CURSOR = "Default";
    public static final String EQUALITY_CURSOR = "Equality";
    public static final String GREATER_CURSOR = "Greater";
    public static final String LESS_CURSOR = "Less";
    public static final String REGEX_CURSOR = "Regex";
    private Panel m_mainPnl = new Panel();
    private JTabbedPane m_tabbedPane = new JTabbedPane();
    private JPanel m_listPnl = new JPanel();
    private JPanel m_cursorPnl = new JPanel();
    private JPanel m_resultsPnl = new JPanel();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTable m_resultsTbl = new JTable();
    private JPanel m_buttonPnl = new JPanel();
    private JButton m_doneBut = new JButton();
    private JLabel jLabel1 = new JLabel();
    private JTextField m_keyText = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JComboBox m_cursorType = new JComboBox();
    private JButton m_scanBut = new JButton();
    private Index m_index = null;

    public IndexDialog(Frame parent, boolean modal, Index a_index) {
        super(parent, modal);
        this.m_index = a_index;
        this.initGUI();
    }

    private void initGUI() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                IndexDialog.this.closeDialog();
            }
        });
        this.pack();
        this.setTitle("Index On Attribute '" + this.m_index.getAttribute() + "'");
        this.setBounds(new Rectangle(0, 0, 512, 471));
        this.getContentPane().add((Component)this.m_mainPnl, "Center");
        this.m_mainPnl.setLayout(new BorderLayout());
        this.m_mainPnl.add((Component)this.m_tabbedPane, "Center");
        this.m_tabbedPane.add((Component)this.m_listPnl, "Listing");
        this.m_listPnl.setLayout(new GridBagLayout());
        this.m_listPnl.add((Component)this.m_cursorPnl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.15, 11, 1, new Insets(15, 0, 30, 0), 0, 0));
        this.m_listPnl.add((Component)this.m_resultsPnl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.8, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_listPnl.add((Component)this.m_buttonPnl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.05, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_cursorPnl.setLayout(new GridBagLayout());
        this.m_cursorPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Display Cursor Constraints", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.m_cursorPnl.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 10), 0, 0));
        this.m_cursorPnl.add((Component)this.m_keyText, new GridBagConstraints(1, 1, 1, 1, 0.4, 0.0, 17, 1, new Insets(5, 5, 5, 236), 0, 0));
        this.m_cursorPnl.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 10), 0, 0));
        this.m_cursorPnl.add((Component)this.m_cursorType, new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.m_resultsPnl.setLayout(new BorderLayout());
        this.m_resultsPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Scan Results", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.m_resultsPnl.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add(this.m_resultsTbl);
        this.m_buttonPnl.setLayout(new FlowLayout(1, 15, 5));
        this.m_buttonPnl.add(this.m_doneBut);
        this.m_buttonPnl.add(this.m_scanBut);
        this.m_doneBut.setText("Done");
        this.m_doneBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Key Constraint:");
        this.m_keyText.setText("");
        this.m_keyText.setMinimumSize(new Dimension(130, 20));
        this.m_keyText.setPreferredSize(new Dimension(130, 20));
        this.m_keyText.setMaximumSize(new Dimension(130, 20));
        this.m_keyText.setFont(new Font("SansSerif", 0, 14));
        this.m_keyText.setSize(new Dimension(130, 20));
        this.jLabel2.setText("Cursor Type:");
        this.m_cursorType.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.m_cursorType.setMinimumSize(new Dimension(126, 20));
        this.m_cursorType.setPreferredSize(new Dimension(130, 20));
        DefaultComboBoxModel<String> l_comboModel = new DefaultComboBoxModel<String>();
        l_comboModel.addElement(DEFAULT_CURSOR);
        l_comboModel.addElement(EQUALITY_CURSOR);
        l_comboModel.addElement(GREATER_CURSOR);
        l_comboModel.addElement(LESS_CURSOR);
        l_comboModel.addElement(REGEX_CURSOR);
        this.m_cursorType.setModel(l_comboModel);
        this.m_cursorType.setMaximumRowCount(5);
        this.m_scanBut.setText("Scan");
        this.m_scanBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.doScan(IndexDialog.this.m_keyText.getText(), (String)IndexDialog.this.m_cursorType.getSelectedItem());
            }
        });
        this.doScan(null, DEFAULT_CURSOR);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean doScan(String a_key, String a_scanType) {
        if (a_key == null || a_key.trim().equals("")) {
            a_key = null;
        }
        if (a_key == null && a_scanType != DEFAULT_CURSOR) {
            JOptionPane.showMessageDialog(null, "Cannot use a " + a_scanType + " scan type with a null key constraint.", "Missing Key Constraint", 0);
            return false;
        }
        try {
            IndexEnumeration l_list = null;
            if (a_scanType == EQUALITY_CURSOR) {
                l_list = this.m_index.listIndices(a_key);
            } else if (a_scanType == GREATER_CURSOR) {
                l_list = this.m_index.listIndices(a_key, true);
            } else if (a_scanType == LESS_CURSOR) {
                l_list = this.m_index.listIndices(a_key, false);
            } else if (a_scanType == REGEX_CURSOR) {
                RE l_regex = StringTools.getRegex(a_key);
                int l_starIndex = a_key.indexOf(42);
                if (l_starIndex > 0) {
                    String l_prefix = a_key.substring(0, l_starIndex);
                    System.out.println("Regex prefix = " + l_prefix);
                    l_list = this.m_index.listIndices(l_regex, l_prefix);
                } else {
                    l_list = this.m_index.listIndices(l_regex);
                }
            } else {
                l_list = this.m_index.listIndices();
            }
            Object[] l_cols = new Object[2];
            Object[] l_row = null;
            l_cols[0] = "Keys ( Attribute Value )";
            l_cols[1] = "Values ( Entry Id )";
            DefaultTableModel l_model = new DefaultTableModel(l_cols, 0);
            int l_count = 0;
            while (l_list.hasMore()) {
                IndexRecord l_rec = (IndexRecord)l_list.next();
                l_row = new Object[]{l_rec.getIndexKey(), l_rec.getEntryId()};
                l_model.addRow(l_row);
                ++l_count;
            }
            this.m_resultsTbl.setModel(l_model);
            this.m_resultsPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Scan Results: " + l_count, 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
            if (this.isVisible()) {
                this.validate();
            }
        }
        catch (Exception e) {
            String l_msg = ExceptionUtils.getStackTrace(e);
            if (l_msg.length() > 1024) {
                l_msg = String.valueOf(l_msg.substring(0, 1024)) + "\n. . . TRUNCATED . . .";
            }
            l_msg = "Error while scanning index on attribute " + this.m_index.getAttribute() + " using a " + a_scanType + " cursor type with a key constraint of '" + a_key + "':\n" + l_msg;
            JTextArea l_area = new JTextArea();
            l_area.setText(l_msg);
            JOptionPane.showMessageDialog(null, l_area, "Index Scan Error", 0);
            return false;
        }
        return true;
    }
}

