/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.operational;

import java.util.HashSet;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.UsageEnum;
import org.apache.ldap.common.util.DateUtils;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.RootNexus;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.ResultFilteringEnumeration;
import org.apache.ldap.server.db.SearchResultFilter;
import org.apache.ldap.server.interceptor.BaseInterceptor;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.Add;
import org.apache.ldap.server.invocation.List;
import org.apache.ldap.server.invocation.Lookup;
import org.apache.ldap.server.invocation.LookupWithAttrIds;
import org.apache.ldap.server.invocation.Modify;
import org.apache.ldap.server.invocation.ModifyMany;
import org.apache.ldap.server.invocation.ModifyRN;
import org.apache.ldap.server.invocation.Move;
import org.apache.ldap.server.invocation.MoveAndModifyRN;
import org.apache.ldap.server.invocation.Search;
import org.apache.ldap.server.jndi.ProviderNexusAspect;
import org.apache.ldap.server.schema.AttributeTypeRegistry;

public class OperationalAttributeService
extends BaseInterceptor {
    private final SearchResultFilter SEARCH_FILTER = new SearchResultFilter(){

        public boolean accept(LdapContext ctx, SearchResult result, SearchControls controls) throws NamingException {
            if (controls.getReturningAttributes() == null) {
                return OperationalAttributeService.this.filter(result.getAttributes());
            }
            return true;
        }
    };
    private RootNexus nexus;
    private AttributeTypeRegistry registry;

    public void init(InterceptorContext ctx) throws NamingException {
        this.nexus = ctx.getRootNexus();
        this.registry = ctx.getGlobalRegistries().getAttributeTypeRegistry();
    }

    public void destroy() {
    }

    protected void process(NextInterceptor nextInterceptor, Add call) throws NamingException {
        String principal = BaseInterceptor.getPrincipal(call).getName();
        Attributes entry = call.getAttributes();
        BasicAttribute attribute = new BasicAttribute("creatorsName");
        attribute.add(principal);
        entry.put(attribute);
        attribute = new BasicAttribute("createTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        entry.put(attribute);
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Modify call) throws NamingException {
        nextInterceptor.process(call);
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("modifiersName");
        attribute.add(BaseInterceptor.getPrincipal(call).getName());
        attributes.put(attribute);
        attribute = new BasicAttribute("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put(attribute);
        BasicAttributes basicAttributes = attributes;
        int n = 2;
        Name name = call.getName();
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            rootNexus.modify(name, n, basicAttributes);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
    }

    protected void process(NextInterceptor nextInterceptor, ModifyMany call) throws NamingException {
        nextInterceptor.process(call);
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("modifiersName");
        attribute.add(BaseInterceptor.getPrincipal(call).getName());
        attributes.put(attribute);
        attribute = new BasicAttribute("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put(attribute);
        BasicAttributes basicAttributes = attributes;
        int n = 2;
        Name name = call.getName();
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            rootNexus.modify(name, n, basicAttributes);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
    }

    protected void process(NextInterceptor nextInterceptor, ModifyRN call) throws NamingException {
        nextInterceptor.process(call);
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("modifiersName");
        attribute.add(BaseInterceptor.getPrincipal(call).getName());
        attributes.put(attribute);
        attribute = new BasicAttribute("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put(attribute);
        Name newDn = call.getName().getSuffix(1).add(call.getNewRelativeName());
        BasicAttributes basicAttributes = attributes;
        int n = 2;
        Name name = newDn;
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            rootNexus.modify(name, n, basicAttributes);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
    }

    protected void process(NextInterceptor nextInterceptor, Move call) throws NamingException {
        nextInterceptor.process(call);
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("modifiersName");
        attribute.add(BaseInterceptor.getPrincipal(call).getName());
        attributes.put(attribute);
        attribute = new BasicAttribute("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put(attribute);
        BasicAttributes basicAttributes = attributes;
        int n = 2;
        Name name = call.getNewParentName();
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            rootNexus.modify(name, n, basicAttributes);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
    }

    protected void process(NextInterceptor nextInterceptor, MoveAndModifyRN call) throws NamingException {
        nextInterceptor.process(call);
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("modifiersName");
        attribute.add(BaseInterceptor.getPrincipal(call).getName());
        attributes.put(attribute);
        attribute = new BasicAttribute("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put(attribute);
        BasicAttributes basicAttributes = attributes;
        int n = 2;
        Name name = call.getNewParentName();
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            rootNexus.modify(name, n, basicAttributes);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
    }

    protected void process(NextInterceptor nextInterceptor, Lookup call) throws NamingException {
        nextInterceptor.process(call);
        Attributes attributes = (Attributes)call.getReturnValue();
        Attributes retval = (Attributes)attributes.clone();
        this.filter(retval);
        call.setReturnValue(retval);
    }

    protected void process(NextInterceptor nextInterceptor, LookupWithAttrIds call) throws NamingException {
        nextInterceptor.process(call);
        Attributes attributes = (Attributes)call.getReturnValue();
        if (attributes == null) {
            return;
        }
        Attributes retval = (Attributes)attributes.clone();
        this.filter(call.getName(), retval, call.getAttributeIds());
        call.setReturnValue(retval);
    }

    protected void process(NextInterceptor nextInterceptor, List call) throws NamingException {
        nextInterceptor.process(call);
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        NamingEnumeration e = (NamingEnumeration)call.getReturnValue();
        ResultFilteringEnumeration retval = new ResultFilteringEnumeration(e, new SearchControls(), ctx, this.SEARCH_FILTER);
        call.setReturnValue(retval);
    }

    protected void process(NextInterceptor nextInterceptor, Search call) throws NamingException {
        nextInterceptor.process(call);
        SearchControls searchControls = call.getControls();
        if (searchControls.getReturningAttributes() != null) {
            return;
        }
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        NamingEnumeration e = (NamingEnumeration)call.getReturnValue();
        ResultFilteringEnumeration retval = new ResultFilteringEnumeration(e, searchControls, ctx, this.SEARCH_FILTER);
        call.setReturnValue(retval);
    }

    private boolean filter(Attributes attributes) throws NamingException {
        NamingEnumeration<String> list = attributes.getIDs();
        while (list.hasMore()) {
            String attrId = list.next();
            AttributeType type = null;
            if (this.registry.hasAttributeType(attrId)) {
                type = this.registry.lookup(attrId);
            }
            if (type == null || type.getUsage() == UsageEnum.USERAPPLICATIONS) continue;
            attributes.remove(attrId);
        }
        return true;
    }

    private void filter(Name dn, Attributes entry, String[] ids) throws NamingException {
        if (ids == null) {
            this.filter(entry);
            return;
        }
        if (dn.size() == 0) {
            HashSet<String> idsSet = new HashSet<String>(ids.length);
            int ii = 0;
            while (ii < ids.length) {
                idsSet.add(ids[ii].toLowerCase());
                ++ii;
            }
            NamingEnumeration<String> list = entry.getIDs();
            while (list.hasMore()) {
                String attrId = ((String)list.nextElement()).toLowerCase();
                if (idsSet.contains(attrId)) continue;
                entry.remove(attrId);
            }
        }
    }
}

