/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.socket;

import java.net.SocketException;
import org.apache.mina.common.BaseSessionConfig;
import org.apache.mina.io.socket.SocketSession;

public class SocketSessionConfig
extends BaseSessionConfig {
    private static final int DEFAULT_READ_BUFFER_SIZE = 1024;
    private final SocketSession session;
    private int readBufferSize = 1024;

    SocketSessionConfig(SocketSession session) {
        this.session = session;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.session.getChannel().socket().getKeepAlive();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.session.getChannel().socket().setKeepAlive(on);
    }

    public boolean getOOBInline() throws SocketException {
        return this.session.getChannel().socket().getOOBInline();
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.session.getChannel().socket().setOOBInline(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.session.getChannel().socket().getReuseAddress();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.session.getChannel().socket().setReuseAddress(on);
    }

    public int getSoLinger() throws SocketException {
        return this.session.getChannel().socket().getSoLinger();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.session.getChannel().socket().setSoLinger(on, linger);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.session.getChannel().socket().getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.session.getChannel().socket().setTcpNoDelay(on);
    }

    public int getTrafficClass() throws SocketException {
        return this.session.getChannel().socket().getTrafficClass();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.session.getChannel().socket().setTrafficClass(tc);
    }

    public int getSendBufferSize() throws SocketException {
        return this.session.getChannel().socket().getSendBufferSize();
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.session.getChannel().socket().setSendBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.session.getChannel().socket().getReceiveBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.session.getChannel().socket().setReceiveBufferSize(size);
    }

    public int getSessionReceiveBufferSize() {
        return this.readBufferSize;
    }

    public void setSessionReceiveBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid session receive buffer size: " + size);
        }
        this.readBufferSize = size;
    }
}

