/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.crypto;

import java.io.UnsupportedEncodingException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class DesStringToKey {
    private byte[] _desKey;

    public DesStringToKey(String passPhrase) {
        this._desKey = this.generateKey(passPhrase);
    }

    public DesStringToKey(String password, String realmName, String userName) {
        this._desKey = this.generateKey(password + realmName + userName);
    }

    public byte[] getKey() {
        return this._desKey;
    }

    private byte[] generateKey(String passPhrase) {
        byte[] encodedByteArray = this.characterEncodeString(passPhrase);
        byte[] paddedByteArray = this.padString(encodedByteArray);
        byte[] secretKey = this.fanFold(paddedByteArray);
        DESParameters.setOddParity((byte[])secretKey);
        if (DESParameters.isWeakKey((byte[])secretKey, (int)0)) {
            secretKey = this.getStrongKey(secretKey);
        }
        secretKey = this.encryptSecretKey(paddedByteArray, secretKey);
        DESParameters.setOddParity((byte[])secretKey);
        if (DESParameters.isWeakKey((byte[])secretKey, (int)0)) {
            secretKey = this.getStrongKey(secretKey);
        }
        return secretKey;
    }

    private byte[] fanFold(byte[] paddedByteArray) {
        byte[] secretKey = new byte[8];
        int i = paddedByteArray.length / 8;
        for (int x = 0; x < i; ++x) {
            byte[] blockValue1 = new byte[8];
            System.arraycopy(paddedByteArray, x * 8, blockValue1, 0, 8);
            if (x % 2 == 1) {
                byte tempbyte1 = 0;
                byte tempbyte2 = 0;
                byte[] blockValue2 = new byte[8];
                for (int y = 0; y < 8; ++y) {
                    int z;
                    tempbyte2 = 0;
                    for (z = 0; z < 4; ++z) {
                        tempbyte2 = (byte)(1 << 7 - z & 0xFF);
                        tempbyte1 = (byte)(tempbyte1 | (blockValue1[y] & tempbyte2) >>> 7 - 2 * z);
                        tempbyte2 = 0;
                    }
                    for (z = 4; z < 8; ++z) {
                        tempbyte2 = (byte)(1 << 7 - z & 0xFF);
                        tempbyte1 = (byte)(tempbyte1 | (blockValue1[y] & tempbyte2) << 2 * z - 7);
                        tempbyte2 = 0;
                    }
                    blockValue2[7 - y] = tempbyte1;
                    tempbyte1 = 0;
                }
                for (int a = 0; a < 8; ++a) {
                    blockValue2[a] = (byte)((blockValue2[a] & 0xFF) >>> 1 & 0xFF);
                }
                System.arraycopy(blockValue2, 0, blockValue1, 0, blockValue2.length);
            }
            for (int a = 0; a < 8; ++a) {
                blockValue1[a] = (byte)((blockValue1[a] & 0xFF) << 1 & 0xFF);
            }
            for (int b = 0; b < 8; ++b) {
                int n = b;
                secretKey[n] = (byte)(secretKey[n] ^ blockValue1[b]);
            }
        }
        return secretKey;
    }

    private byte[] encryptSecretKey(byte[] data, byte[] key) {
        CBCBlockCipher cipher = new CBCBlockCipher((BlockCipher)new DESEngine());
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV iv = new ParametersWithIV((CipherParameters)kp, key);
        cipher.init(true, (CipherParameters)iv);
        byte[] encKey = new byte[data.length];
        byte[] ivBytes = new byte[8];
        for (int x = 0; x < data.length / 8; ++x) {
            cipher.processBlock(data, x * 8, encKey, x * 8);
            System.arraycopy(encKey, x * 8, ivBytes, 0, 8);
            iv = new ParametersWithIV((CipherParameters)kp, ivBytes);
            cipher.init(true, (CipherParameters)iv);
        }
        return ivBytes;
    }

    private byte[] getStrongKey(byte[] keyValue) {
        keyValue[7] = (byte)(keyValue[7] ^ 0xF0);
        return keyValue;
    }

    private byte[] characterEncodeString(String str) {
        byte[] encodedByteArray = new byte[str.length()];
        try {
            encodedByteArray = str.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedByteArray;
    }

    private byte[] padString(byte[] encodedString) {
        int x = encodedString.length < 8 ? encodedString.length : encodedString.length % 8;
        if (x == 0) {
            return encodedString;
        }
        byte[] paddedByteArray = new byte[8 - x + encodedString.length];
        for (int y = paddedByteArray.length - 1; y > encodedString.length - 1; --y) {
            paddedByteArray[y] = 0;
        }
        System.arraycopy(encodedString, 0, paddedByteArray, 0, encodedString.length);
        return paddedByteArray;
    }
}

