/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.crypto.checksum;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ChecksumType
implements Comparable {
    public static final ChecksumType NULL = new ChecksumType(0, "null");
    public static final ChecksumType CRC32 = new ChecksumType(1, "CRC32");
    public static final ChecksumType RSA_MD4 = new ChecksumType(2, "RSA MD4");
    public static final ChecksumType RSA_MD4_DES = new ChecksumType(3, "RSA MD4 DES");
    public static final ChecksumType DES_MAC = new ChecksumType(4, "DES MAC");
    public static final ChecksumType DES_MAC_K = new ChecksumType(5, "DES MAC K");
    public static final ChecksumType RSA_MD4_DES_K = new ChecksumType(6, "RSA MD4 DES K");
    public static final ChecksumType RSA_MD5 = new ChecksumType(7, "RSA MD5");
    public static final ChecksumType RSA_MD5_DES = new ChecksumType(8, "RSA MD5 DES");
    public static final ChecksumType RSA_MD5_DES3 = new ChecksumType(9, "RSA MD5 DES3");
    public static final ChecksumType SHA1 = new ChecksumType(10, "SHA1");
    public static final ChecksumType UNKNOWN11 = new ChecksumType(11, "UNKNOWN 11");
    public static final ChecksumType HMAC_SHA1_DES3 = new ChecksumType(12, "HMAC SHA1 DES3");
    private final String _fName;
    private final int _fOrdinal;
    private static final ChecksumType[] fValues = new ChecksumType[]{NULL, CRC32, RSA_MD4, RSA_MD4_DES, DES_MAC, DES_MAC_K, RSA_MD4_DES_K, RSA_MD5, RSA_MD5_DES, RSA_MD5_DES3, SHA1, UNKNOWN11, HMAC_SHA1_DES3};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(fValues));

    public String toString() {
        return this._fName;
    }

    public int compareTo(Object that) {
        return this._fOrdinal - ((ChecksumType)that)._fOrdinal;
    }

    public static ChecksumType getTypeByOrdinal(int type) {
        for (int i = 0; i < fValues.length; ++i) {
            if (ChecksumType.fValues[i]._fOrdinal != type) continue;
            return fValues[i];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this._fOrdinal;
    }

    private ChecksumType(int ordinal, String name) {
        this._fOrdinal = ordinal;
        this._fName = name;
    }
}

