/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.asn1.der.ASN1InputStream;
import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.decoder.EncryptedDataDecoder;
import org.apache.kerberos.messages.MessageType;
import org.apache.kerberos.messages.application.PrivateMessage;

public class PrivateMessageDecoder {
    public PrivateMessage decode(byte[] encodedPrivateMessage) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedPrivateMessage);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence privateMessage = (DERSequence)app.getObject();
        return this.decodePrivateMessageSequence(privateMessage);
    }

    private PrivateMessage decodePrivateMessageSequence(DERSequence sequence) {
        PrivateMessage message = new PrivateMessage();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    message.setProtocolVersionNumber(tag0.intValue());
                    break;
                }
                case 1: {
                    DERInteger tag1 = (DERInteger)derObject;
                    message.setMessageType(MessageType.getTypeByOrdinal(tag1.intValue()));
                    break;
                }
                case 3: {
                    DERSequence tag3 = (DERSequence)derObject;
                    message.setEncryptedPart(EncryptedDataDecoder.decode(tag3));
                }
            }
        }
        return message;
    }
}

