/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERGeneralString;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.decoder.EncryptedDataDecoder;
import org.apache.kerberos.io.decoder.PrincipalNameDecoder;
import org.apache.kerberos.messages.components.Ticket;
import org.apache.kerberos.messages.components.TicketModifier;

public class TicketDecoder {
    public static Ticket[] decodeSequence(DERSequence sequence) throws IOException {
        Ticket[] tickets = new Ticket[sequence.size()];
        int ii = 0;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERApplicationSpecific object = (DERApplicationSpecific)e.nextElement();
            tickets[ii] = TicketDecoder.decode(object);
        }
        return tickets;
    }

    protected static Ticket decode(DERApplicationSpecific app) throws IOException {
        DERSequence sequence = (DERSequence)app.getObject();
        TicketModifier modifier = new TicketModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    modifier.setTicketVersionNumber(tag0.intValue());
                    break;
                }
                case 1: {
                    DERGeneralString tag1 = (DERGeneralString)derObject;
                    modifier.setServerRealm(tag1.getString());
                    break;
                }
                case 2: {
                    DERSequence tag2 = (DERSequence)derObject;
                    modifier.setServerName(PrincipalNameDecoder.decode(tag2));
                    break;
                }
                case 3: {
                    DERSequence tag3 = (DERSequence)derObject;
                    modifier.setEncPart(EncryptedDataDecoder.decode(tag3));
                }
            }
        }
        return modifier.getTicket();
    }
}

