/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERGeneralString;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.encoder.EncryptedDataEncoder;
import org.apache.kerberos.io.encoder.PrincipalNameEncoder;
import org.apache.kerberos.messages.components.Ticket;

public class TicketEncoder {
    protected static DERApplicationSpecific encode(Ticket ticket) {
        DERSequence vector = new DERSequence();
        vector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)ticket.getTicketVersionNumber())));
        vector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERGeneralString.valueOf((String)ticket.getRealm())));
        vector.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)PrincipalNameEncoder.encode(ticket.getServerPrincipal())));
        vector.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)EncryptedDataEncoder.encodeSequence(ticket.getEncPart())));
        DERApplicationSpecific ticketSequence = null;
        try {
            ticketSequence = DERApplicationSpecific.valueOf((int)1, (DEREncodable)vector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ticketSequence;
    }

    protected static DERSequence encodeSequence(Ticket[] tickets) {
        DERSequence outerVector = new DERSequence();
        for (int ii = 0; ii < tickets.length; ++ii) {
            DERSequence vector = new DERSequence();
            vector.add((DEREncodable)TicketEncoder.encode(tickets[ii]));
            outerVector.add((DEREncodable)vector);
        }
        return outerVector;
    }
}

