/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.checksum.ChecksumType;
import org.apache.kerberos.crypto.checksum.Crc32Checksum;
import org.apache.kerberos.crypto.checksum.RsaMd4Checksum;
import org.apache.kerberos.crypto.checksum.RsaMd5Checksum;
import org.apache.kerberos.crypto.checksum.Sha1Checksum;
import org.apache.kerberos.crypto.encryption.EncryptionEngine;
import org.apache.kerberos.crypto.encryption.EncryptionEngineFactory;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.exceptions.ErrorType;
import org.apache.kerberos.exceptions.KerberosException;
import org.apache.kerberos.io.decoder.AuthenticatorDecoder;
import org.apache.kerberos.io.decoder.EncTicketPartDecoder;
import org.apache.kerberos.messages.ApplicationRequest;
import org.apache.kerberos.messages.MessageType;
import org.apache.kerberos.messages.components.Authenticator;
import org.apache.kerberos.messages.components.EncTicketPart;
import org.apache.kerberos.messages.components.EncTicketPartModifier;
import org.apache.kerberos.messages.components.Ticket;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.replay.InMemoryReplayCache;
import org.apache.kerberos.replay.ReplayCache;
import org.apache.kerberos.service.KdcConfiguration;
import org.apache.kerberos.store.PrincipalStore;
import org.apache.kerberos.store.PrincipalStoreEntry;
import org.apache.kerberos.store.operations.GetPrincipal;

public class KerberosService {
    protected KdcConfiguration config;
    protected PrincipalStore store;
    private ReplayCache replayCache = new InMemoryReplayCache();
    private Map checksumEngines = new HashMap();

    public KerberosService(KdcConfiguration config, PrincipalStore store) {
        this.config = config;
        this.store = store;
        this.checksumEngines.put(ChecksumType.CRC32, new Crc32Checksum());
        this.checksumEngines.put(ChecksumType.RSA_MD4, new RsaMd4Checksum());
        this.checksumEngines.put(ChecksumType.RSA_MD5, new RsaMd5Checksum());
        this.checksumEngines.put(ChecksumType.SHA1, new Sha1Checksum());
    }

    public EncryptionKey getClientKey(KerberosPrincipal clientPrincipal) throws KerberosException {
        return this.getKey(clientPrincipal, ErrorType.KDC_ERR_C_PRINCIPAL_UNKNOWN);
    }

    public EncryptionKey getServerKey(KerberosPrincipal serverPrincipal) throws KerberosException {
        return this.getKey(serverPrincipal, ErrorType.KDC_ERR_S_PRINCIPAL_UNKNOWN);
    }

    private EncryptionKey getKey(KerberosPrincipal principal, ErrorType errorType) throws KerberosException {
        PrincipalStoreEntry entry = null;
        try {
            entry = (PrincipalStoreEntry)this.store.execute(new GetPrincipal(principal));
        }
        catch (Exception e) {
            throw new KerberosException(errorType);
        }
        if (entry == null || entry.getEncryptionKey() == null) {
            throw new KerberosException(errorType);
        }
        return entry.getEncryptionKey();
    }

    public PrincipalStoreEntry getEntryForClient(KerberosPrincipal clientPrincipal) throws KerberosException {
        PrincipalStoreEntry entry = null;
        try {
            entry = (PrincipalStoreEntry)this.store.execute(new GetPrincipal(clientPrincipal));
        }
        catch (Exception e) {
            throw new KerberosException(ErrorType.KDC_ERR_C_PRINCIPAL_UNKNOWN);
        }
        if (entry == null) {
            throw new KerberosException(ErrorType.KDC_ERR_C_PRINCIPAL_UNKNOWN);
        }
        return entry;
    }

    protected EncryptionType getBestEncryptionType(EncryptionType[] requestedTypes) throws KerberosException {
        EncryptionType[] encryptionTypes = this.config.getEncryptionTypes();
        for (int ii = 0; ii < requestedTypes.length; ++ii) {
            for (int jj = 0; jj < encryptionTypes.length; ++jj) {
                if (requestedTypes[ii] != encryptionTypes[jj]) continue;
                return encryptionTypes[jj];
            }
        }
        throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
    }

    protected void verifyTicket(Ticket ticket, KerberosPrincipal serverPrincipal) throws KerberosException {
        if (!ticket.getRealm().equals(this.config.getPrimaryRealm()) && !ticket.getServerPrincipal().equals(serverPrincipal)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
    }

    protected Authenticator verifyAuthHeader(ApplicationRequest authHeader, Ticket ticket) throws KerberosException, IOException {
        Authenticator authenticator;
        if (authHeader.getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        if (authHeader.getMessageType() != MessageType.KRB_AP_REQ) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
        }
        if (authHeader.getTicket().getTicketVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        KerberosPrincipal serverPrincipal = ticket.getServerPrincipal();
        EncryptionKey serverKey = null;
        serverKey = authHeader.getOption(1) ? authHeader.getTicket().getSessionKey() : this.getServerKey(serverPrincipal);
        if (serverKey == null) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOKEY);
        }
        try {
            EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor(serverKey);
            byte[] decTicketPart = engine.getDecryptedData(serverKey, ticket.getEncPart());
            EncTicketPartDecoder ticketPartDecoder = new EncTicketPartDecoder();
            EncTicketPart encPart = ticketPartDecoder.decode(decTicketPart);
            ticket.setEncTicketPart(encPart);
        }
        catch (KerberosException ke) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
        }
        try {
            EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor(ticket.getSessionKey());
            byte[] decAuthenticator = engine.getDecryptedData(ticket.getSessionKey(), authHeader.getEncPart());
            AuthenticatorDecoder authDecoder = new AuthenticatorDecoder();
            authenticator = authDecoder.decode(decAuthenticator);
        }
        catch (KerberosException ke) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
        }
        if (!authenticator.getClientPrincipal().getName().equals(ticket.getClientPrincipal().getName())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADMATCH);
        }
        if (ticket.getClientAddresses() != null) {
            // empty if block
        }
        if (this.replayCache.isReplay(authenticator.getClientTime(), authenticator.getClientPrincipal())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_REPEAT);
        }
        this.replayCache.save(authenticator.getClientTime(), authenticator.getClientPrincipal());
        if (!authenticator.getClientTime().isInClockSkew(this.config.getClockSkew())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_SKEW);
        }
        if (ticket.getStartTime() != null && !ticket.getStartTime().isInClockSkew(this.config.getClockSkew()) || ticket.getFlag(7)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
        }
        if (!ticket.getEndTime().greaterThan(new KerberosTime())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
        }
        authHeader.setOption(2);
        return authenticator;
    }

    protected void echoTicket(EncTicketPartModifier newTicketBody, Ticket tgt) {
        newTicketBody.setAuthorizationData(tgt.getAuthorizationData());
        newTicketBody.setAuthTime(tgt.getAuthTime());
        newTicketBody.setClientAddresses(tgt.getClientAddresses());
        newTicketBody.setClientPrincipal(tgt.getClientPrincipal());
        newTicketBody.setEndTime(tgt.getEndTime());
        newTicketBody.setFlags(tgt.getFlags());
        newTicketBody.setRenewTill(tgt.getRenewTill());
        newTicketBody.setSessionKey(tgt.getSessionKey());
        newTicketBody.setTransitedEncoding(tgt.getTransitedEncoding());
    }
}

