/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder;

import org.apache.asn1.ber.digester.BERDigester;
import org.apache.asn1.ber.digester.rules.Octets2StringRule;
import org.apache.asn1.ber.digester.rules.PopOnFinish;
import org.apache.asn1.ber.digester.rules.PrimitiveIntDecodeRule;
import org.apache.asn1.ber.digester.rules.PrimitiveOctetStringRule;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.decoder.ErrorMessageRule;
import org.apache.ldap.common.berlib.asn1.decoder.ReferralRule;
import org.apache.ldap.common.berlib.asn1.decoder.ReferralUrlRule;
import org.apache.ldap.common.berlib.asn1.decoder.ResultCodeRule;
import org.apache.ldap.common.berlib.asn1.decoder.ResultMatchedDNRule;
import org.apache.ldap.common.berlib.asn1.decoder.abandon.AbandonRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.add.AddAttributeValueRule;
import org.apache.ldap.common.berlib.asn1.decoder.add.AddRequestAttributesRule;
import org.apache.ldap.common.berlib.asn1.decoder.add.AddRequestEntryDnRule;
import org.apache.ldap.common.berlib.asn1.decoder.add.AddRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.add.AddResponseRule;
import org.apache.ldap.common.berlib.asn1.decoder.bind.BindNameRule;
import org.apache.ldap.common.berlib.asn1.decoder.bind.BindRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.bind.BindResponseRule;
import org.apache.ldap.common.berlib.asn1.decoder.bind.BindSimpleCredentialsRule;
import org.apache.ldap.common.berlib.asn1.decoder.bind.BindVersionRule;
import org.apache.ldap.common.berlib.asn1.decoder.compare.CompareAVARule;
import org.apache.ldap.common.berlib.asn1.decoder.compare.CompareEntryRule;
import org.apache.ldap.common.berlib.asn1.decoder.compare.CompareRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.compare.CompareResponseRule;
import org.apache.ldap.common.berlib.asn1.decoder.delete.DeleteRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.delete.DeleteResponseRule;
import org.apache.ldap.common.berlib.asn1.decoder.extended.ExtendedRequestOidRule;
import org.apache.ldap.common.berlib.asn1.decoder.extended.ExtendedRequestPayloadRule;
import org.apache.ldap.common.berlib.asn1.decoder.extended.ExtendedRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.extended.ExtendedResponseOidRule;
import org.apache.ldap.common.berlib.asn1.decoder.extended.ExtendedResponsePayloadRule;
import org.apache.ldap.common.berlib.asn1.decoder.extended.ExtendedResponseRule;
import org.apache.ldap.common.berlib.asn1.decoder.modify.ModificationItemRule;
import org.apache.ldap.common.berlib.asn1.decoder.modify.ModifyRequestAttributeValueRule;
import org.apache.ldap.common.berlib.asn1.decoder.modify.ModifyRequestEntryDnRule;
import org.apache.ldap.common.berlib.asn1.decoder.modify.ModifyRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.modify.ModifyResponseRule;
import org.apache.ldap.common.berlib.asn1.decoder.modifydn.ModifyDnRequestDeleteOldRdnRule;
import org.apache.ldap.common.berlib.asn1.decoder.modifydn.ModifyDnRequestEntryRule;
import org.apache.ldap.common.berlib.asn1.decoder.modifydn.ModifyDnRequestNewRdnRule;
import org.apache.ldap.common.berlib.asn1.decoder.modifydn.ModifyDnRequestNewSuperiorRule;
import org.apache.ldap.common.berlib.asn1.decoder.modifydn.ModifyDnRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.modifydn.ModifyDnResponseRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.AndRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.ApproxMatchRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.BaseObjectRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.DerefAliasRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.EqualityMatchRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.ExtensibleMatchDnAttributesRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.ExtensibleMatchMatchingRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.ExtensibleMatchRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.ExtensibleMatchTypeRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.ExtensibleMatchValueRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.GreaterOrEqualRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.LessOrEqualRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.NotRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.OrRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.PresentRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.RequestedAttributesRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.RequestedAttributesStateChangeRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.ScopeRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchRequestRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchResponseDoneRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchResponseEntryAttributesRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchResponseEntryDnRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchResponseEntryRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchResponseReferenceRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchResponseReferralRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SizeLimitRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SubstringMatchAnyRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SubstringMatchFinalRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SubstringMatchInitialRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.SubstringMatchRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.TerminateFilterStateRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.TimeLimitRule;
import org.apache.ldap.common.berlib.asn1.decoder.search.TypesOnlyRule;
import org.apache.ldap.common.berlib.asn1.decoder.unbind.UnbindRequestRule;

public class LdapDigesterFactory {
    private static LdapDigesterFactory singleton;

    private LdapDigesterFactory() {
        singleton = this;
    }

    public static LdapDigesterFactory getSingleton() {
        if (singleton == null) {
            singleton = new LdapDigesterFactory();
        }
        return singleton;
    }

    public BERDigester create() {
        BERDigester digester = new BERDigester();
        this.addMessageIdRules(digester);
        this.addAbandonRequestRules(digester);
        this.addAddResponseRules(digester);
        this.addAddRequestRules(digester);
        this.addUnbindRequestRules(digester);
        this.addBindRequestRules(digester);
        this.addBindResponseRules(digester);
        this.addCompareRequestRules(digester);
        this.addCompareResponseRules(digester);
        this.addDeleteRequestRules(digester);
        this.addDeleteResponseRules(digester);
        this.addExtendedRequestRules(digester);
        this.addExtendedResponseRules(digester);
        this.addModifyDnRequestRules(digester);
        this.addModifyDnResponseRules(digester);
        this.addModifyRequestRules(digester);
        this.addModifyResponseRules(digester);
        this.addSearchRequestRules(digester);
        this.addSearchResponseDoneRules(digester);
        this.addSearchResponseReferenceRules(digester);
        this.addSearchResponseEntryRules(digester);
        return digester;
    }

    private void addSearchRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_REQUEST.getPrimitiveTag()};
        digester.addRule(pattern, new SearchRequestRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_REQUEST.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new BaseObjectRule());
        pattern[2] = UniversalTag.ENUMERATED.getPrimitiveTag();
        digester.addRule(pattern, new ScopeRule());
        digester.addRule(pattern, new DerefAliasRule());
        pattern[2] = UniversalTag.INTEGER.getPrimitiveTag();
        digester.addRule(pattern, new SizeLimitRule());
        digester.addRule(pattern, new TimeLimitRule());
        pattern[2] = UniversalTag.BOOLEAN.getPrimitiveTag();
        digester.addRule(pattern, new TypesOnlyRule());
        pattern[2] = UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag();
        digester.addRule(pattern, new TerminateFilterStateRule());
        digester.addRule(pattern, new RequestedAttributesStateChangeRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new RequestedAttributesRule());
        pattern = new int[]{0x1FFFFFFF, LdapTag.CONTEXT_SPECIFIC_TAG_7.getPrimitiveTag()};
        digester.addRule(pattern, new PresentRule());
        pattern = new int[]{0x1FFFFFFF, LdapTag.CONTEXT_SPECIFIC_TAG_3.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new EqualityMatchRule());
        pattern[1] = LdapTag.CONTEXT_SPECIFIC_TAG_4.getPrimitiveTag();
        digester.addRule(pattern, new Octets2StringRule());
        pattern[2] = UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag();
        digester.addRule(pattern, new SubstringMatchRule());
        pattern = new int[]{0x1FFFFFFF, LdapTag.CONTEXT_SPECIFIC_TAG_4.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.CONTEXT_SPECIFIC_TAG_0.getPrimitiveTag()};
        digester.addRule(pattern, new SubstringMatchInitialRule());
        pattern[3] = LdapTag.CONTEXT_SPECIFIC_TAG_1.getPrimitiveTag();
        digester.addRule(pattern, new SubstringMatchAnyRule());
        pattern[3] = LdapTag.CONTEXT_SPECIFIC_TAG_2.getPrimitiveTag();
        digester.addRule(pattern, new SubstringMatchFinalRule());
        pattern = new int[]{0x1FFFFFFF, LdapTag.CONTEXT_SPECIFIC_TAG_5.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new GreaterOrEqualRule());
        pattern[1] = LdapTag.CONTEXT_SPECIFIC_TAG_6.getPrimitiveTag();
        digester.addRule(pattern, new LessOrEqualRule());
        pattern[1] = LdapTag.CONTEXT_SPECIFIC_TAG_8.getPrimitiveTag();
        digester.addRule(pattern, new ApproxMatchRule());
        pattern = new int[]{0x1FFFFFFF, LdapTag.CONTEXT_SPECIFIC_TAG_9.getPrimitiveTag()};
        digester.addRule(pattern, new ExtensibleMatchRule());
        pattern = new int[]{0x1FFFFFFF, LdapTag.CONTEXT_SPECIFIC_TAG_9.getPrimitiveTag(), LdapTag.CONTEXT_SPECIFIC_TAG_1.getPrimitiveTag()};
        digester.addRule(pattern, new ExtensibleMatchMatchingRule());
        pattern[2] = LdapTag.CONTEXT_SPECIFIC_TAG_2.getPrimitiveTag();
        digester.addRule(pattern, new ExtensibleMatchTypeRule());
        pattern[2] = LdapTag.CONTEXT_SPECIFIC_TAG_3.getPrimitiveTag();
        digester.addRule(pattern, new ExtensibleMatchValueRule());
        pattern[2] = LdapTag.CONTEXT_SPECIFIC_TAG_4.getPrimitiveTag();
        digester.addRule(pattern, new ExtensibleMatchDnAttributesRule());
        pattern = new int[]{0x1FFFFFFF, LdapTag.CONTEXT_SPECIFIC_TAG_0.getPrimitiveTag()};
        digester.addRule(pattern, new AndRule());
        pattern[1] = LdapTag.CONTEXT_SPECIFIC_TAG_1.getPrimitiveTag();
        digester.addRule(pattern, new OrRule());
        pattern[1] = LdapTag.CONTEXT_SPECIFIC_TAG_2.getPrimitiveTag();
        digester.addRule(pattern, new NotRule());
    }

    private void addModifyRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_REQUEST.getPrimitiveTag()};
        digester.addRule(pattern, new ModifyRequestRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_REQUEST.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ModifyRequestEntryDnRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.ENUMERATED.getPrimitiveTag()};
        digester.addRule(pattern, new PrimitiveIntDecodeRule(UniversalTag.ENUMERATED));
        pattern[4] = UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag();
        digester.addRule(pattern, new PopOnFinish());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ModificationItemRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SET_SET_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ModifyRequestAttributeValueRule());
    }

    private void addSearchResponseEntryRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_ENTRY.getPrimitiveTag()};
        digester.addRule(pattern, new SearchResponseEntryRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_ENTRY.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new SearchResponseEntryDnRule());
        pattern[0] = UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag();
        pattern[1] = LdapTag.SEARCH_RESULT_ENTRY.getPrimitiveTag();
        pattern[2] = UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag();
        digester.addRule(pattern, new SearchResponseEntryAttributesRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_ENTRY.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag()};
        digester.addRule(pattern, new PopOnFinish());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_ENTRY.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new Octets2StringRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_ENTRY.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SET_SET_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new AddAttributeValueRule());
    }

    private void addAddRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_REQUEST.getPrimitiveTag()};
        digester.addRule(pattern, new AddRequestRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_REQUEST.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new AddRequestEntryDnRule());
        pattern[0] = UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag();
        pattern[1] = LdapTag.ADD_REQUEST.getPrimitiveTag();
        pattern[2] = UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag();
        digester.addRule(pattern, new AddRequestAttributesRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag()};
        digester.addRule(pattern, new PopOnFinish());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new Octets2StringRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.SET_SET_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new AddAttributeValueRule());
    }

    private void addSearchResponseReferenceRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_REFERENCE.getPrimitiveTag()};
        digester.addRule(pattern, new SearchResponseReferenceRule());
        digester.addRule(pattern, new SearchResponseReferralRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_REFERENCE.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addSearchResponseDoneRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_DONE.getPrimitiveTag()};
        digester.addRule(pattern, new SearchResponseDoneRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_DONE.getPrimitiveTag(), UniversalTag.ENUMERATED.getPrimitiveTag()};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.SEARCH_RESULT_DONE.getPrimitiveTag(), LdapTag.REFERRAL_TAG.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addModifyResponseRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_RESPONSE.getPrimitiveTag()};
        digester.addRule(pattern, new ModifyResponseRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_RESPONSE.getPrimitiveTag(), UniversalTag.ENUMERATED.getPrimitiveTag()};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFY_RESPONSE.getPrimitiveTag(), LdapTag.REFERRAL_TAG.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addAddResponseRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_RESPONSE.getPrimitiveTag()};
        digester.addRule(pattern, new AddResponseRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_RESPONSE.getPrimitiveTag(), UniversalTag.ENUMERATED.getPrimitiveTag()};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.ADD_RESPONSE.getPrimitiveTag(), LdapTag.REFERRAL_TAG.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addModifyDnRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFYDN_REQUEST.getPrimitiveTag()};
        digester.addRule(pattern, new ModifyDnRequestRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFYDN_REQUEST.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ModifyDnRequestEntryRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ModifyDnRequestNewRdnRule());
        pattern[2] = UniversalTag.BOOLEAN.getPrimitiveTag();
        digester.addRule(pattern, new ModifyDnRequestDeleteOldRdnRule());
        pattern[2] = LdapTag.MODIFYDN_REQUEST_NEWSUP_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ModifyDnRequestNewSuperiorRule());
    }

    private void addModifyDnResponseRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFYDN_RESPONSE.getPrimitiveTag()};
        digester.addRule(pattern, new ModifyDnResponseRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFYDN_RESPONSE.getPrimitiveTag(), UniversalTag.ENUMERATED.getPrimitiveTag()};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.MODIFYDN_RESPONSE.getPrimitiveTag(), LdapTag.REFERRAL_TAG.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addExtendedRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.EXTENDED_REQUEST.getPrimitiveTag()};
        digester.addRule(pattern, new ExtendedRequestRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.EXTENDED_REQUEST.getPrimitiveTag(), LdapTag.EXTENDED_REQUEST_NAME_TAG.getPrimitiveTag()};
        digester.addRule(pattern, new ExtendedRequestOidRule());
        pattern[2] = LdapTag.EXTENDED_REQUEST_VALUE_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ExtendedRequestPayloadRule());
    }

    private void addExtendedResponseRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.EXTENDED_RESPONSE.getPrimitiveTag()};
        digester.addRule(pattern, new ExtendedResponseRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.EXTENDED_RESPONSE.getPrimitiveTag(), UniversalTag.ENUMERATED.getPrimitiveTag()};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern[2] = LdapTag.EXTENDED_RESPONSE_NAME_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ExtendedResponseOidRule());
        pattern[2] = LdapTag.EXTENDED_RESPONSE_VALUE_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ExtendedResponsePayloadRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.EXTENDED_RESPONSE.getPrimitiveTag(), LdapTag.REFERRAL_TAG.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addMessageIdRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getValue(), UniversalTag.INTEGER.getValue()};
        digester.addRule(pattern, new PrimitiveIntDecodeRule());
    }

    private void addDeleteResponseRules(BERDigester digester) {
        int[] pattern = new int[]{0x10000000, 0x4B000000};
        digester.addRule(pattern, new DeleteResponseRule());
        pattern = new int[]{0x10000000, 0x4B000000, 0xA000000};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = 0x4000000;
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern = new int[]{0x10000000, 0x4B000000, LdapTag.REFERRAL_TAG.getPrimitiveTag(), 0x4000000};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addDeleteRequestRules(BERDigester digester) {
        int[] pattern = new int[]{0x10000000, LdapTag.DEL_REQUEST.getPrimitiveTag()};
        digester.addRule(pattern, new DeleteRequestRule());
    }

    private void addCompareRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.COMPARE_REQUEST.getPrimitiveTag()};
        digester.addRule(pattern, new CompareRequestRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.COMPARE_REQUEST.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new CompareEntryRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.COMPARE_REQUEST.getPrimitiveTag(), UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new CompareAVARule());
    }

    private void addCompareResponseRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.COMPARE_RESPONSE.getPrimitiveTag()};
        digester.addRule(pattern, new CompareResponseRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.COMPARE_RESPONSE.getPrimitiveTag(), 0xA000000};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.COMPARE_RESPONSE.getPrimitiveTag(), LdapTag.REFERRAL_TAG.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addBindResponseRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.BIND_RESPONSE.getPrimitiveTag()};
        digester.addRule(pattern, new BindResponseRule());
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.BIND_RESPONSE.getPrimitiveTag(), UniversalTag.ENUMERATED.getPrimitiveTag()};
        digester.addRule(pattern, new ResultCodeRule());
        pattern[2] = UniversalTag.OCTET_STRING.getPrimitiveTag();
        digester.addRule(pattern, new ResultMatchedDNRule());
        digester.addRule(pattern, new ErrorMessageRule());
        pattern[2] = LdapTag.REFERRAL_TAG.getPrimitiveTag();
        digester.addRule(pattern, new ReferralRule());
        pattern[2] = LdapTag.SERVER_SASL_CREDS_TAG.getPrimitiveTag();
        digester.addRule(pattern, new PrimitiveOctetStringRule(LdapTag.SERVER_SASL_CREDS_TAG));
        pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getPrimitiveTag(), LdapTag.BIND_RESPONSE.getPrimitiveTag(), LdapTag.REFERRAL_TAG.getPrimitiveTag(), UniversalTag.OCTET_STRING.getPrimitiveTag()};
        digester.addRule(pattern, new ReferralUrlRule());
    }

    private void addBindRequestRules(BERDigester digester) {
        int[] reqPat = new int[]{0x10000000, 0x40000000};
        digester.addRule(reqPat, new BindRequestRule());
        int[] versionPat = new int[]{0x10000000, 0x40000000, 0x2000000};
        digester.addRule(versionPat, new BindVersionRule());
        int[] namePat = new int[]{0x10000000, 0x40000000, 0x4000000};
        digester.addRule(namePat, new BindNameRule());
        int[] credPat = new int[]{0x10000000, 0x40000000, Integer.MIN_VALUE};
        digester.addRule(credPat, new BindSimpleCredentialsRule());
    }

    private void addUnbindRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getValue(), LdapTag.UNBIND_REQUEST.getValue()};
        digester.addRule(pattern, new UnbindRequestRule());
    }

    private void addAbandonRequestRules(BERDigester digester) {
        int[] pattern = new int[]{UniversalTag.SEQUENCE_SEQUENCE_OF.getValue(), LdapTag.ABANDON_REQUEST.getValue()};
        digester.addRule(pattern, new AbandonRequestRule());
    }
}

