/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder;

import org.apache.asn1.ber.DeterminateLengthVisitor;
import org.apache.asn1.ber.TupleEncodingVisitor;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.EncoderCallback;
import org.apache.asn1.codec.stateful.EncoderMonitor;
import org.apache.asn1.codec.stateful.StatefulEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.abandon.AbandonRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.add.AddRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.add.AddResponseEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.bind.BindRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.bind.BindResponseEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.compare.CompareRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.compare.CompareResponseEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.delete.DeleteRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.delete.DeleteResponseEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.extended.ExtendedRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.extended.ExtendedResponseEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.modify.ModifyRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.modify.ModifyResponseEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.modifyDn.ModifyDnRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.modifyDn.ModifyDnResponseEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.search.SearchRequestEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.search.SearchResponseDoneEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.search.SearchResponseEntryEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.search.SearchResponseReferenceEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.unbind.UnbindRequestEncoder;
import org.apache.ldap.common.message.AbandonRequest;
import org.apache.ldap.common.message.AddRequest;
import org.apache.ldap.common.message.AddResponse;
import org.apache.ldap.common.message.BindRequest;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.CompareRequest;
import org.apache.ldap.common.message.CompareResponse;
import org.apache.ldap.common.message.DeleteRequest;
import org.apache.ldap.common.message.DeleteResponse;
import org.apache.ldap.common.message.ExtendedRequest;
import org.apache.ldap.common.message.ExtendedResponse;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ModifyDnRequest;
import org.apache.ldap.common.message.ModifyDnResponse;
import org.apache.ldap.common.message.ModifyRequest;
import org.apache.ldap.common.message.ModifyResponse;
import org.apache.ldap.common.message.SearchRequest;
import org.apache.ldap.common.message.SearchResponseDone;
import org.apache.ldap.common.message.SearchResponseEntry;
import org.apache.ldap.common.message.SearchResponseReference;
import org.apache.ldap.common.message.UnbindRequest;

public class SnickersLdapEncoder
implements StatefulEncoder {
    EncoderMonitor monitor;
    TupleEncodingVisitor encoder = new TupleEncodingVisitor();
    DeterminateLengthVisitor lengthVisitor = new DeterminateLengthVisitor();

    public void encode(Object obj) throws EncoderException {
        Message msg = (Message)obj;
        TupleNode root = null;
        switch (msg.getType().getValue()) {
            case 0x40000010: {
                root = AbandonRequestEncoder.INSTANCE.encode((AbandonRequest)msg);
                break;
            }
            case 0x40000008: {
                root = AddRequestEncoder.INSTANCE.encode((AddRequest)msg);
                break;
            }
            case 0x40000009: {
                root = AddResponseEncoder.INSTANCE.encode((AddResponse)msg);
                break;
            }
            case 0x40000000: {
                root = BindRequestEncoder.INSTANCE.encode((BindRequest)msg);
                break;
            }
            case 0x40000001: {
                root = BindResponseEncoder.INSTANCE.encode((BindResponse)msg);
                break;
            }
            case 0x4000000E: {
                root = CompareRequestEncoder.INSTANCE.encode((CompareRequest)msg);
            }
            case 0x4000000F: {
                root = CompareResponseEncoder.INSTANCE.encode((CompareResponse)msg);
                break;
            }
            case 0x4000000A: {
                root = DeleteRequestEncoder.INSTANCE.encode((DeleteRequest)msg);
                break;
            }
            case 0x4000000B: {
                root = DeleteResponseEncoder.INSTANCE.encode((DeleteResponse)msg);
                break;
            }
            case 1073741847: {
                root = ExtendedRequestEncoder.INSTANCE.encode((ExtendedRequest)msg);
                break;
            }
            case 1073741848: {
                root = ExtendedResponseEncoder.INSTANCE.encode((ExtendedResponse)msg);
                break;
            }
            case 0x40000006: {
                root = ModifyRequestEncoder.INSTANCE.encode((ModifyRequest)msg);
                break;
            }
            case 0x40000007: {
                root = ModifyResponseEncoder.INSTANCE.encode((ModifyResponse)msg);
                break;
            }
            case 0x4000000C: {
                root = ModifyDnRequestEncoder.INSTANCE.encode((ModifyDnRequest)msg);
                break;
            }
            case 0x4000000D: {
                root = ModifyDnResponseEncoder.INSTANCE.encode((ModifyDnResponse)msg);
                break;
            }
            case 0x40000003: {
                root = SearchRequestEncoder.INSTANCE.encode((SearchRequest)msg);
                break;
            }
            case 0x40000005: {
                root = SearchResponseDoneEncoder.INSTANCE.encode((SearchResponseDone)msg);
                break;
            }
            case 0x40000004: {
                root = SearchResponseEntryEncoder.INSTANCE.encode((SearchResponseEntry)msg);
                break;
            }
            case 1073741843: {
                root = SearchResponseReferenceEncoder.INSTANCE.encode((SearchResponseReference)msg);
                break;
            }
            case 0x40000002: {
                root = UnbindRequestEncoder.INSTANCE.encode((UnbindRequest)msg);
                break;
            }
            default: {
                IllegalArgumentException e = new IllegalArgumentException("Unable to encode unrecognized object: " + obj);
                if (this.monitor != null) {
                    this.monitor.error(this, e);
                }
                throw e;
            }
        }
        root.accept(this.lengthVisitor);
        root.accept(this.encoder);
        this.encoder.flush();
    }

    public void setCallback(EncoderCallback cb) {
        this.encoder.setCallback(cb);
        if (this.monitor != null) {
            this.monitor.callbackSet(this, null, cb);
            return;
        }
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
        this.monitor = monitor;
        this.encoder.setEncoderMonitor(monitor);
    }
}

