/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder.extended;

import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;
import org.apache.ldap.common.berlib.asn1.encoder.LdapResultEncoder;
import org.apache.ldap.common.message.ExtendedResponse;

public class ExtendedResponseEncoder {
    public static final ExtendedResponseEncoder INSTANCE = new ExtendedResponseEncoder();

    public TupleNode encode(ExtendedResponse response) {
        DefaultMutableTupleNode top = new DefaultMutableTupleNode(new Tuple());
        top.getTuple().setTag(UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        top.getTuple().setLength(-2);
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode(response.getMessageId());
        top.addLast(child);
        child.setParent(top);
        DefaultMutableTupleNode extResp = new DefaultMutableTupleNode(new Tuple());
        extResp.getTuple().setTag(LdapTag.EXTENDED_RESPONSE, false);
        extResp.getTuple().setLength(-2);
        LdapResultEncoder.INSTANCE.encode(extResp, response.getLdapResult());
        if (response.getResponseName() != null) {
            child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_10, response.getResponseName());
            extResp.addLast(child);
            child.setParent(extResp);
        }
        if (response.getResponse() != null) {
            child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_11, response.getResponse());
            extResp.addLast(child);
            child.setParent(extResp);
        }
        top.addLast(extResp);
        extResp.setParent(top);
        return top;
    }
}

