/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.message.Control;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.MessageTypeEnum;

public class AbstractMessage
extends AbstractLockable
implements Message {
    private final Map controls;
    private final int id;
    private final MessageTypeEnum type;
    private final Map parameters;

    protected AbstractMessage(int id, MessageTypeEnum type) {
        super(true);
        this.id = id;
        this.type = type;
        this.controls = new HashMap();
        this.parameters = new HashMap();
    }

    public int getMessageId() {
        return this.id;
    }

    public Collection getControls() {
        return Collections.unmodifiableCollection(this.controls.values());
    }

    public void add(Control control) throws MessageException {
        this.lockCheck("Attempt to add control to locked message envelope!");
        this.controls.put(control.getType(), control);
    }

    public void remove(Control control) throws MessageException {
        this.lockCheck("Attempt to remove control from locked message envelope!");
        this.controls.remove(control.getType());
    }

    public MessageTypeEnum getType() {
        return this.type;
    }

    public Object get(Object key) {
        return this.parameters.get(key);
    }

    public Object put(Object key, Object value) {
        return this.parameters.put(key, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message msg = (Message)obj;
        if (msg.getMessageId() != this.id) {
            return false;
        }
        if (msg.getType() != this.type) {
            return false;
        }
        Collection controls = msg.getControls();
        if (controls.size() != this.controls.size()) {
            return false;
        }
        Iterator list = this.controls.values().iterator();
        while (list.hasNext()) {
            if (controls.contains(list.next())) continue;
            return false;
        }
        return true;
    }
}

