/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.Referral;
import org.apache.ldap.common.message.ResultCodeEnum;

public class LdapResultImpl
extends AbstractLockable
implements LdapResult {
    private String matchedDn;
    private Referral referral;
    private String errorMessage;
    private ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;

    public LdapResultImpl(Lockable parent) {
        super(parent, false);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.lockCheck("Attempt to alter error message of locked LdapResult!");
        this.errorMessage = errorMessage;
    }

    public String getMatchedDn() {
        return this.matchedDn;
    }

    public void setMatchedDn(String matchedDn) {
        this.lockCheck("Attempt to alter matchedDn of locked LdapResult!");
        this.matchedDn = matchedDn;
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.lockCheck("Attempt to alter the resultCode of a locked LdapResult!");
        this.resultCode = resultCode;
    }

    public Referral getReferral() {
        return this.referral;
    }

    public boolean isReferral() {
        return this.referral != null;
    }

    public void setReferral(Referral referral) {
        this.lockCheck("Attempt to alter the referral of a locked LdapResult!");
        this.referral = referral;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LdapResult)) {
            return false;
        }
        LdapResult result = (LdapResult)obj;
        if (this.referral == null && result.getReferral() != null) {
            return false;
        }
        if (result.getReferral() == null && this.referral != null) {
            return false;
        }
        if (this.referral != null && result.getReferral() != null && !this.referral.equals(result.getReferral())) {
            return false;
        }
        if (!this.resultCode.equals(result.getResultCode())) {
            return false;
        }
        String errMsg0 = this.errorMessage;
        String errMsg1 = result.getErrorMessage();
        if (errMsg0 == null) {
            errMsg0 = "";
        }
        if (errMsg1 == null) {
            errMsg1 = "";
        }
        if (!errMsg0.equals(errMsg1)) {
            return false;
        }
        return !(this.matchedDn != null ? !this.matchedDn.equals(result.getMatchedDn()) : result.getMatchedDn() != null);
    }
}

