/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.CompareRequest;
import org.apache.ldap.common.message.CompareResponseImpl;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;

public class CompareHandler
implements MessageHandler {
    public void messageReceived(ProtocolSession session, Object request) {
        CompareRequest req = (CompareRequest)request;
        CompareResponseImpl resp = new CompareResponseImpl(req.getMessageId());
        resp.setLdapResult(new LdapResultImpl(resp));
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            Attribute attr = ctx.getAttributes(req.getName()).get(req.getAttributeId());
            if (attr == null) {
                resp.getLdapResult().setResultCode(ResultCodeEnum.COMPAREFALSE);
            } else if (attr.contains(req.getAssertionValue())) {
                resp.getLdapResult().setResultCode(ResultCodeEnum.COMPARETRUE);
            } else {
                resp.getLdapResult().setResultCode(ResultCodeEnum.COMPAREFALSE);
            }
        }
        catch (NamingException e) {
            String msg = "failed to add entry " + req.getName() + ":\n";
            msg = msg + ExceptionUtils.getStackTrace(e);
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)((Object)e)).getResultCode() : ResultCodeEnum.getBestEstimate(e, req.getType());
            resp.getLdapResult().setResultCode(code);
            resp.getLdapResult().setErrorMessage(msg);
            if (e.getResolvedName() != null) {
                resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
            }
            session.write(resp);
            return;
        }
        resp.getLdapResult().setMatchedDn(req.getName());
        session.write(resp);
    }
}

