/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.ldap.server.schema.OidRegistry;
import org.apache.ldap.server.schema.OidRegistryMonitor;
import org.apache.ldap.server.schema.OidRegistryMonitorAdapter;

public class BootstrapOidRegistry
implements OidRegistry {
    private Hashtable byOid = new Hashtable();
    private Hashtable byName = new Hashtable();
    private OidRegistryMonitor monitor = new OidRegistryMonitorAdapter();

    public String getOid(String name) throws NamingException {
        if (name == null) {
            throw new NamingException("name should not be null");
        }
        if (Character.isDigit(name.charAt(0))) {
            this.monitor.getOidWithOid(name);
            return name;
        }
        if (this.byName.containsKey(name)) {
            String oid = (String)this.byName.get(name);
            this.monitor.oidResolved(name, oid);
            return oid;
        }
        String lowerCase = name.trim().toLowerCase();
        if (!name.equals(lowerCase) && this.byName.containsKey(lowerCase)) {
            String oid = (String)this.byName.get(lowerCase);
            this.monitor.oidResolved(name, lowerCase, oid);
            this.byName.put(name, oid);
            return oid;
        }
        NamingException fault = new NamingException("OID for name '" + name + "' was not " + "found within the OID registry");
        this.monitor.oidResolutionFailed(name, fault);
        throw fault;
    }

    public boolean hasOid(String name) {
        return this.byName.containsKey(name) || this.byOid.containsKey(name);
    }

    public String getPrimaryName(String oid) throws NamingException {
        Object value = this.byOid.get(oid);
        if (value == null) {
            NamingException fault = new NamingException("OID '" + oid + "' was not found within the OID registry");
            this.monitor.oidDoesNotExist(oid, fault);
            throw fault;
        }
        if (value instanceof String) {
            this.monitor.nameResolved(oid, (String)value);
            return (String)value;
        }
        String name = (String)((List)value).get(0);
        this.monitor.nameResolved(oid, name);
        return name;
    }

    public List getNameSet(String oid) throws NamingException {
        Object value = this.byOid.get(oid);
        if (value == null) {
            NamingException fault = new NamingException("OID '" + oid + "' was not found within the OID registry");
            this.monitor.oidDoesNotExist(oid, fault);
            throw fault;
        }
        if (value instanceof String) {
            List list = Collections.singletonList(value);
            this.monitor.namesResolved(oid, list);
            return list;
        }
        this.monitor.namesResolved(oid, (List)value);
        return (List)value;
    }

    public Iterator list() {
        return Collections.unmodifiableSet(this.byOid.keySet()).iterator();
    }

    public void register(String name, String oid) {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new RuntimeException("Swap the parameter order: the oid does not start with a digit!");
        }
        String lowerCase = name.toLowerCase();
        if (!lowerCase.equals(name)) {
            this.byName.put(lowerCase, oid);
        }
        this.byName.put(name, oid);
        this.byName.put(oid, oid);
        Object value = null;
        if (!this.byOid.containsKey(oid)) {
            value = name;
        } else {
            ArrayList<String> list = null;
            value = this.byOid.get(oid);
            if (value instanceof String) {
                Object existingName = value;
                if (((String)existingName).equalsIgnoreCase(name)) {
                    return;
                }
                list = new ArrayList<String>();
                list.add((String)value);
                value = list;
            } else if (value instanceof ArrayList) {
                list = (ArrayList<String>)value;
                int ii = 0;
                while (ii < list.size()) {
                    if (!name.equalsIgnoreCase((String)list.get(ii))) {
                        return;
                    }
                    ++ii;
                }
                list.add(name);
            }
        }
        this.byOid.put(oid, value);
        this.monitor.registered(name, oid);
    }

    OidRegistryMonitor getMonitor() {
        return this.monitor;
    }

    void setMonitor(OidRegistryMonitor monitor) {
        this.monitor = monitor;
    }
}

