/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enum.EnumUtils;
import org.apache.commons.lang.enum.ValuedEnum;

public final class BERDecoderState
extends ValuedEnum {
    public static final int TAG_VAL = 0;
    public static final int LENGTH_VAL = 1;
    public static final int VALUE_VAL = 2;
    public static final BERDecoderState TAG = new BERDecoderState("TAG", 0);
    public static final BERDecoderState LENGTH = new BERDecoderState("LENGTH", 1);
    public static final BERDecoderState VALUE = new BERDecoderState("VALUE", 2);

    private BERDecoderState(String name, int value) {
        super(name, value);
    }

    public final BERDecoderState getNext(boolean isPrimitive) {
        BERDecoderState next = null;
        switch (this.getValue()) {
            case 2: {
                next = TAG;
                break;
            }
            case 0: {
                next = LENGTH;
                break;
            }
            case 1: {
                next = isPrimitive ? VALUE : TAG;
            }
        }
        return next;
    }

    public final boolean isEndState(boolean isPrimitive) {
        boolean isEndState = false;
        switch (this.getValue()) {
            case 2: {
                isEndState = true;
                break;
            }
            case 0: {
                isEndState = false;
                break;
            }
            case 1: {
                isEndState = !isPrimitive;
            }
        }
        return isEndState;
    }

    public static final BERDecoderState getStartState() {
        return TAG;
    }

    public static final BERDecoderState getState(String stateName) {
        if (stateName == TAG.getName()) {
            return TAG;
        }
        if (stateName == LENGTH.getName()) {
            return LENGTH;
        }
        if (stateName == VALUE.getName()) {
            return VALUE;
        }
        if (stateName.equalsIgnoreCase(TAG.getName())) {
            return TAG;
        }
        if (stateName.equalsIgnoreCase(LENGTH.getName())) {
            return LENGTH;
        }
        if (stateName.equalsIgnoreCase(VALUE.getName())) {
            return VALUE;
        }
        throw new IllegalArgumentException("Unknown decoder state" + stateName);
    }

    public static final List list() {
        return EnumUtils.getEnumList(BERDecoderState.class);
    }

    public static final Map map() {
        return EnumUtils.getEnumMap(BERDecoderState.class);
    }

    public static final BERDecoderState getState(int value) {
        switch (value) {
            case 0: {
                return TAG;
            }
            case 1: {
                return LENGTH;
            }
            case 2: {
                return VALUE;
            }
        }
        throw new IllegalStateException("Should not be here!");
    }
}

