/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import org.apache.asn1.ber.TagOctetCollector;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.codec.DecoderException;

public class Tag {
    private static final int CONSTRUCTED_FLAG = 32;
    static final int SHORT_MASK = 31;
    static final int LONG_MASK = 127;
    private static final int LONG_FLAG = 128;
    private static final int ONE_OCTET_IDMAX = 30;
    private static final int TWO_OCTET_IDMAX = 127;
    private static final int THREE_OCTET_IDMAX = 16383;
    private static final int FOUR_OCTET_IDMAX = 0x1FFFFF;
    private int id = 0;
    private boolean isPrimitive = true;
    private boolean isFixated = false;
    private TypeClass typeClass = TypeClass.APPLICATION;
    private final TagOctetCollector buf = new TagOctetCollector();

    void clear() {
        this.id = 0;
        this.isFixated = false;
        this.isPrimitive = true;
        this.typeClass = TypeClass.APPLICATION;
        this.buf.clear();
    }

    void fixate() throws DecoderException {
        this.isFixated = true;
        this.id = Tag.getTagId(this.buf);
        this.isPrimitive = Tag.isPrimitive(this.buf.get(0));
        this.typeClass = TypeClass.getTypeClass(this.buf.get(0));
    }

    void add(byte octet) throws DecoderException {
        if (this.isFixated) {
            throw new IllegalStateException("data added to fixated tag");
        }
        this.buf.put(octet);
        if (this.buf.size() == 1) {
            if ((0x1F & octet) != 31) {
                this.fixate();
            }
        } else if ((octet & 0x80) == 0) {
            this.fixate();
        }
    }

    public byte[] getOctets() {
        return this.buf.toArray();
    }

    public int size() {
        return this.buf.size();
    }

    public int getId() {
        return this.id;
    }

    public int getRawTag() {
        return this.buf.getIntValue();
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isFixated() {
        return this.isFixated;
    }

    public TypeClass getTypeClass() {
        return this.typeClass;
    }

    public static final int setIntEncodedId(int encodedTag, int id) {
        if (id <= 30) {
            encodedTag |= id << 24;
        } else if (id <= 127) {
            encodedTag |= 0x1F000000;
            encodedTag |= (id & 0x7F) << 16;
        } else if (id <= 16383) {
            encodedTag |= 0x1F000000;
            encodedTag |= (id & 0x3F80) << 9;
            encodedTag |= (id & 0x7F) << 8;
            encodedTag |= 0x800000;
        } else if (id <= 0x1FFFFF) {
            encodedTag |= 0x1F000000;
            encodedTag |= (id & 0x1FC000) << 2;
            encodedTag |= (id & 0x3F80) << 1;
            encodedTag |= id & 0x7F;
            encodedTag |= 0x808000;
        } else {
            String msg = "Id argument value of " + id + " was greater than the maximum supported id of " + 0x1FFFFF;
            throw new IllegalArgumentException(msg);
        }
        return encodedTag;
    }

    public static final int getIntEncodedTag(TypeClass type, int id, boolean isConstructed) {
        int value = type.getValue() << 24;
        if (isConstructed) {
            value |= 0x20000000;
        }
        value = Tag.setIntEncodedId(value, id);
        return value;
    }

    public static final int getTagId(byte[] octets) throws DecoderException {
        if (octets.length > 4) {
            throw new DecoderException("Tag number is too large.");
        }
        int id = octets[0] & 0x1F;
        if (id != 31 && octets.length == 1) {
            return id;
        }
        id = 0;
        for (int ii = 1; ii < octets.length; ++ii) {
            id = id << 7 | octets[ii] & 0x7F;
        }
        return id;
    }

    public static final int getTagId(int octets) {
        int id = octets >> 24 & 0x1F;
        if (id != 31) {
            return id;
        }
        id = 0;
        int octet = (octets & 0xFF0000) >> 16;
        id |= octet & 0x7F;
        if ((octet & 0x80) == 0) {
            return id;
        }
        octet = 0;
        octet = (octets & 0xFF00) >> 8;
        if (octet == 0) {
            return id << 7;
        }
        id <<= 7;
        id |= octet & 0x7F;
        if ((octet & 0x80) == 0) {
            return id;
        }
        octet = 0;
        octet = octets & 0xFF;
        id <<= 7;
        return id |= octet & 0x7F;
    }

    public static final int getTagId(TagOctetCollector octets) {
        int id = octets.get(0) & 0x1F;
        if (id != 31 && octets.size() == 1) {
            return id;
        }
        id = 0;
        for (int ii = 1; ii < octets.size(); ++ii) {
            id = id << 7 | octets.get(ii) & 0x7F;
        }
        return id;
    }

    public static final boolean isPrimitive(int octet) {
        return (octet & 0x20) == 0;
    }

    public static final boolean isConstructed(int octet) {
        return (octet & 0x20) == 32;
    }

    public static boolean isRawTagConstructed(int rawTag) {
        return (rawTag & 0x20000000) > 0;
    }
}

