/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.TupleNodeVisitor;
import org.apache.asn1.ber.VisitorMonitor;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.AbstractStatefulEncoder;

public class TupleEncodingVisitor
extends AbstractStatefulEncoder
implements TupleNodeVisitor {
    private static final ByteBuffer[] EMPTY_ARRAY = new ByteBuffer[0];
    private ArrayList buffers = new ArrayList();
    private VisitorMonitor visitorMonitor = VisitorMonitor.NOOP;

    public void encode(Object obj) throws EncoderException {
        if (obj instanceof DefaultMutableTupleNode) {
            ((DefaultMutableTupleNode)obj).accept(this);
            return;
        }
        throw new IllegalArgumentException("Expected an argument of type DefaultMutableTupleNode but instead got an instance of " + obj.getClass().getName());
    }

    public void visit(TupleNode node) {
        Tuple tlv = node.getTuple();
        int size = tlv.getTagLength() + tlv.getLengthLength();
        ByteBuffer buf = ByteBuffer.wrap(new byte[size]);
        tlv.setTag(buf, tlv.getTagLength());
        tlv.setLength(buf, tlv.getLengthLength());
        this.buffers.add(buf.flip());
        if (tlv.isPrimitive()) {
            this.buffers.add(tlv.getLastValueChunk());
        }
        this.visitorMonitor.visited(this, node);
    }

    public boolean canVisit(TupleNode node) {
        return true;
    }

    public boolean isPrefix() {
        return true;
    }

    public ArrayList getOrder(TupleNode node, ArrayList children) {
        return children;
    }

    public void flush() {
        ByteBuffer[] array = this.buffers.toArray(EMPTY_ARRAY);
        this.buffers.clear();
        super.encodeOccurred(array);
    }

    public void setMonitor(VisitorMonitor monitor) {
        this.visitorMonitor = monitor;
    }
}

