/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.digester.rules;

import java.nio.ByteBuffer;
import org.apache.commons.lang.ArrayUtils;

public class ByteAccumulator {
    private static final int DEFAULT_INIT_SIZE = 0;
    private static final int DEFAULT_INCREMENT = 100;
    private byte[] bs;
    private int pos;
    private int increment;
    private int initial = 0;

    public ByteAccumulator() {
        this.bs = ArrayUtils.EMPTY_BYTE_ARRAY;
        this.pos = 0;
        this.initial = 0;
        this.increment = 100;
    }

    ByteAccumulator(int initial) {
        if (initial <= 0) {
            this.bs = ArrayUtils.EMPTY_BYTE_ARRAY;
            this.initial = 0;
        } else {
            this.bs = new byte[initial];
            this.initial = initial;
        }
        this.pos = 0;
        this.increment = 100;
    }

    public void fill(ByteBuffer buf) {
        while (buf.hasRemaining()) {
            if (this.pos >= this.bs.length) {
                int size = 0;
                size = buf.remaining() > this.increment ? this.bs.length + buf.remaining() : this.bs.length + this.increment;
                byte[] dest = new byte[size];
                System.arraycopy(this.bs, 0, dest, 0, this.bs.length);
                this.bs = dest;
            }
            int spaceLeft = this.bs.length - this.pos;
            if (buf.remaining() <= spaceLeft) {
                int remaining = buf.remaining();
                buf.get(this.bs, this.pos, remaining);
                this.pos += remaining;
                return;
            }
            buf.get(this.bs, this.pos, spaceLeft);
            this.pos += spaceLeft;
        }
    }

    public ByteBuffer drain() {
        ByteBuffer compacted = this.pos == this.bs.length ? ByteBuffer.wrap(this.bs) : ByteBuffer.wrap(this.bs, 0, this.pos);
        this.bs = this.initial <= 0 ? ArrayUtils.EMPTY_BYTE_ARRAY : new byte[this.initial];
        this.pos = 0;
        return compacted;
    }

    public ByteBuffer drain(int initial) {
        ByteBuffer compacted = this.pos == this.bs.length ? ByteBuffer.wrap(this.bs) : ByteBuffer.wrap(this.bs, 0, this.pos);
        this.bs = initial <= 0 ? ArrayUtils.EMPTY_BYTE_ARRAY : new byte[initial];
        this.pos = 0;
        return compacted;
    }

    public void ensureCapacity(int capacity) {
        if (this.bs.length < capacity) {
            byte[] newArray = new byte[capacity];
            if (this.bs != ArrayUtils.EMPTY_BYTE_ARRAY) {
                System.arraycopy(this.bs, 0, newArray, 0, this.pos + 1);
            }
            this.bs = newArray;
        }
    }

    public int getGrowthIncrement() {
        return this.increment;
    }

    public int getInitialSize() {
        return this.initial;
    }

    public int getCapacity() {
        return this.bs.length;
    }

    public int getRemainingSpace() {
        return this.bs.length - this.pos;
    }

    public int getPosition() {
        return this.pos;
    }
}

